/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.message.MessageTrigger;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class HttpStubTrigger
implements MessageTrigger {
    private final UUID stubId;

    @JsonCreator
    public HttpStubTrigger(@JsonProperty(value="stubId") UUID stubId) {
        this.stubId = stubId;
    }

    public static HttpStubTrigger forStubId(UUID stubId) {
        return new HttpStubTrigger(stubId);
    }

    public static HttpStubTrigger forStubId(String stubId) {
        return new HttpStubTrigger(UUID.fromString(stubId));
    }

    public UUID getStubId() {
        return this.stubId;
    }

    public boolean matches(ServeEvent serveEvent) {
        if (serveEvent == null || serveEvent.getStubMapping() == null) {
            return false;
        }
        return this.stubId.equals(serveEvent.getStubMapping().getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpStubTrigger that = (HttpStubTrigger)o;
        return Objects.equals(this.stubId, that.stubId);
    }

    public int hashCode() {
        return Objects.hash(this.stubId);
    }

    public String toString() {
        return "HttpStubTrigger{stubId=" + String.valueOf(this.stubId) + "}";
    }
}

