/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.github.tomakehurst.wiremock.extension.MessageActionTransformer;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.message.ChannelTarget;
import com.github.tomakehurst.wiremock.message.HttpRequestTrigger;
import com.github.tomakehurst.wiremock.message.HttpStubTrigger;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageAction;
import com.github.tomakehurst.wiremock.message.MessageActionContext;
import com.github.tomakehurst.wiremock.message.MessageChannels;
import com.github.tomakehurst.wiremock.message.MessageStubMapping;
import com.github.tomakehurst.wiremock.message.MessageStubMappings;
import com.github.tomakehurst.wiremock.message.MessageStubRequestHandler;
import com.github.tomakehurst.wiremock.message.MessageTrigger;
import com.github.tomakehurst.wiremock.message.RequestInitiatedChannelTarget;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.message.SendMessageAction;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HttpStubServeEventListener
implements ServeEventListener {
    private final MessageStubMappings messageStubMappings;
    private final MessageChannels messageChannels;
    private final Stores stores;
    private final Map<String, RequestMatcherExtension> customMatchers;
    private final List<MessageActionTransformer> actionTransformers;

    public HttpStubServeEventListener(MessageStubMappings messageStubMappings, MessageChannels messageChannels, Stores stores, Map<String, RequestMatcherExtension> customMatchers, List<MessageActionTransformer> actionTransformers) {
        this.messageStubMappings = messageStubMappings;
        this.messageChannels = messageChannels;
        this.stores = stores;
        this.customMatchers = customMatchers != null ? customMatchers : Collections.emptyMap();
        this.actionTransformers = actionTransformers != null ? actionTransformers : Collections.emptyList();
    }

    @Override
    public String getName() {
        return "http-stub-message-trigger";
    }

    @Override
    public boolean applyGlobally() {
        return true;
    }

    @Override
    public void afterMatch(ServeEvent serveEvent, Parameters parameters) {
        if (serveEvent == null || serveEvent.getStubMapping() == null) {
            return;
        }
        List<MessageStubMapping> matchingStubs = this.findMatchingMessageStubs(serveEvent);
        for (MessageStubMapping stub : matchingStubs) {
            this.executeActions(stub, serveEvent);
        }
    }

    private List<MessageStubMapping> findMatchingMessageStubs(ServeEvent serveEvent) {
        return this.messageStubMappings.getAllSortedByPriority().stream().filter(stub -> this.matchesTrigger((MessageStubMapping)stub, serveEvent)).toList();
    }

    private boolean matchesTrigger(MessageStubMapping stub, ServeEvent serveEvent) {
        MessageTrigger trigger = stub.getTrigger();
        if (trigger instanceof HttpStubTrigger) {
            HttpStubTrigger httpStubTrigger = (HttpStubTrigger)trigger;
            return httpStubTrigger.matches(serveEvent);
        }
        if (trigger instanceof HttpRequestTrigger) {
            HttpRequestTrigger httpRequestTrigger = (HttpRequestTrigger)trigger;
            return httpRequestTrigger.matches(serveEvent, this.customMatchers);
        }
        return false;
    }

    private void executeActions(MessageStubMapping stub, ServeEvent httpServeEvent) {
        MessageActionContext context = MessageActionContext.forHttpTrigger(stub, httpServeEvent);
        for (MessageAction action : stub.getActions()) {
            MessageAction transformedAction = this.applyTransformations(action, context);
            this.executeAction(transformedAction);
        }
    }

    private MessageAction applyTransformations(MessageAction action, MessageActionContext context) {
        MessageAction result = action;
        for (MessageActionTransformer transformer : this.actionTransformers) {
            if (!transformer.applyGlobally() && !action.hasTransformer(transformer)) continue;
            result = transformer.transform(result, context);
        }
        return result;
    }

    private void executeAction(MessageAction action) {
        if (action instanceof SendMessageAction) {
            SendMessageAction sendAction = (SendMessageAction)action;
            this.executeSendMessageAction(sendAction);
        }
    }

    private void executeSendMessageAction(SendMessageAction action) {
        Message message = MessageStubRequestHandler.resolveToMessage(action.getMessage(), this.stores);
        ChannelTarget target = action.getChannelTarget();
        if (target instanceof RequestInitiatedChannelTarget) {
            RequestInitiatedChannelTarget requestTarget = (RequestInitiatedChannelTarget)target;
            List<RequestInitiatedMessageChannel> matchingChannels = requestTarget.getChannelType() != null ? this.messageChannels.findByTypeAndRequestPattern(requestTarget.getChannelType(), requestTarget.getRequestPattern(), this.customMatchers) : this.messageChannels.findByRequestPattern(requestTarget.getRequestPattern(), this.customMatchers);
            for (RequestInitiatedMessageChannel channel : matchingChannels) {
                channel.sendMessage(message);
            }
        }
    }
}

