/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.message.MessageTrigger;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class HttpRequestTrigger
implements MessageTrigger {
    private final RequestPattern requestPattern;

    @JsonCreator
    public HttpRequestTrigger(@JsonProperty(value="requestPattern") RequestPattern requestPattern) {
        this.requestPattern = requestPattern;
    }

    public static HttpRequestTrigger forRequestPattern(RequestPattern requestPattern) {
        return new HttpRequestTrigger(requestPattern);
    }

    public RequestPattern getRequestPattern() {
        return this.requestPattern;
    }

    public boolean matches(ServeEvent serveEvent, Map<String, RequestMatcherExtension> customMatchers) {
        if (serveEvent == null || serveEvent.getRequest() == null) {
            return false;
        }
        return this.matches(serveEvent.getRequest(), customMatchers);
    }

    public boolean matches(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        if (this.requestPattern == null) {
            return true;
        }
        MatchResult matchResult = this.requestPattern.match(request, customMatchers);
        return matchResult.isExactMatch();
    }

    public boolean matches(ServeEvent serveEvent) {
        return this.matches(serveEvent, Collections.emptyMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequestTrigger that = (HttpRequestTrigger)o;
        return Objects.equals(this.requestPattern, that.requestPattern);
    }

    public int hashCode() {
        return Objects.hash(this.requestPattern);
    }

    public String toString() {
        return "HttpRequestTrigger{requestPattern=" + String.valueOf(this.requestPattern) + "}";
    }
}

