/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.MatchResult;

public abstract class AbstractNumberMatchResult
extends MatchResult {
    protected static final float EXACT_MATCH = 0.0f;
    protected static final float NO_MATCH = 1.0f;
    private static final double MAX_LOG_DIFF = 176.0;
    private final Double expectedValue;
    private final String value;

    public AbstractNumberMatchResult(Number expectedValue, String value) {
        this.expectedValue = expectedValue.doubleValue();
        this.value = value;
    }

    private static double getShiftValue(double expectedDouble, double actualDouble) {
        if (expectedDouble < 0.0 || actualDouble < 0.0) {
            return Math.min(expectedDouble, actualDouble);
        }
        return 0.0;
    }

    private static boolean areValuesTooBig(double expectedDouble, double actualDouble) {
        return expectedDouble == Double.POSITIVE_INFINITY || actualDouble == Double.POSITIVE_INFINITY || expectedDouble == Double.MAX_VALUE && actualDouble == Double.MAX_VALUE;
    }

    private static double calculateDistance(double expectedDouble, double actualDouble) {
        double logA = Math.log(expectedDouble);
        double logB = Math.log(actualDouble);
        double logDiff = Math.abs(logA - logB);
        double normalized = logDiff / 176.0;
        return (double)Math.round(Math.min(normalized, 1.0) * 100.0) / 100.0;
    }

    protected abstract boolean isExactMatch(double var1, double var3);

    @Override
    public boolean isExactMatch() {
        try {
            double actualDouble = Double.parseDouble(this.value);
            return this.isExactMatch(this.expectedValue, actualDouble);
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
    }

    @Override
    public double getDistance() {
        try {
            double actualDouble;
            double parsedActual = Double.parseDouble(this.value);
            if (this.isExactMatch(this.expectedValue, parsedActual)) {
                return 0.0;
            }
            double shiftValue = AbstractNumberMatchResult.getShiftValue(this.expectedValue, parsedActual);
            double expectedDouble = this.expectedValue + shiftValue;
            if (AbstractNumberMatchResult.areValuesTooBig(expectedDouble, actualDouble = parsedActual + shiftValue)) {
                return 1.0;
            }
            double actualDistance = AbstractNumberMatchResult.calculateDistance(expectedDouble, actualDouble);
            if (actualDistance == 0.0) {
                return 0.01;
            }
            return actualDistance;
        }
        catch (NullPointerException | NumberFormatException e) {
            return 1.0;
        }
    }
}

