/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.Path;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResponseDefinition {
    private final int status;
    private final String statusMessage;
    private final Body body;
    private final String bodyFileName;
    private final @NonNull HttpHeaders headers;
    private final @NonNull HttpHeaders additionalProxyRequestHeaders;
    private final @NonNull List<String> removeProxyRequestHeaders;
    private final Integer fixedDelayMilliseconds;
    private final DelayDistribution delayDistribution;
    private final ChunkedDribbleDelay chunkedDribbleDelay;
    private final @Nullable String proxyBaseUrl;
    private final @Nullable Path proxyUrlPrefixToRemove;
    private final Fault fault;
    private final @NonNull List<String> transformers;
    private final @NonNull Parameters transformerParameters;
    private final @Nullable AbsoluteUrl browserProxyUrl;
    private final Boolean wasConfigured;

    @JsonCreator
    public ResponseDefinition(@JsonProperty(value="status") int status, @JsonProperty(value="statusMessage") String statusMessage, @JsonProperty(value="body") String body, @JsonProperty(value="jsonBody") JsonNode jsonBody, @JsonProperty(value="base64Body") String base64Body, @JsonProperty(value="bodyFileName") String bodyFileName, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="additionalProxyRequestHeaders") HttpHeaders additionalProxyRequestHeaders, @JsonProperty(value="removeProxyRequestHeaders") List<String> removeProxyRequestHeaders, @JsonProperty(value="fixedDelayMilliseconds") Integer fixedDelayMilliseconds, @JsonProperty(value="delayDistribution") DelayDistribution delayDistribution, @JsonProperty(value="chunkedDribbleDelay") ChunkedDribbleDelay chunkedDribbleDelay, @JsonProperty(value="proxyBaseUrl") String proxyBaseUrl, @JsonProperty(value="proxyUrlPrefixToRemove") String proxyUrlPrefixToRemove, @JsonProperty(value="fault") Fault fault, @JsonProperty(value="transformers") List<String> transformers, @JsonProperty(value="transformerParameters") Parameters transformerParameters, @JsonProperty(value="fromConfiguredStub") Boolean wasConfigured) {
        this(status, statusMessage, Body.fromOneOf(null, body, jsonBody, base64Body), bodyFileName, headers, additionalProxyRequestHeaders, removeProxyRequestHeaders, fixedDelayMilliseconds, delayDistribution, chunkedDribbleDelay, proxyBaseUrl, proxyUrlPrefixToRemove != null ? Path.parse((String)proxyUrlPrefixToRemove) : null, fault, transformers, transformerParameters, null, wasConfigured);
    }

    public ResponseDefinition(int status, String statusMessage, Body body, String bodyFileName, HttpHeaders headers, HttpHeaders additionalProxyRequestHeaders, List<String> removeProxyRequestHeaders, Integer fixedDelayMilliseconds, DelayDistribution delayDistribution, ChunkedDribbleDelay chunkedDribbleDelay, @Nullable String proxyBaseUrl, @Nullable Path proxyUrlPrefixToRemove, Fault fault, List<String> transformers, Parameters transformerParameters, @Nullable AbsoluteUrl browserProxyUrl, Boolean wasConfigured) {
        this.status = status > 0 ? status : 200;
        this.statusMessage = statusMessage;
        this.body = body;
        this.bodyFileName = bodyFileName;
        this.headers = headers != null ? headers : new HttpHeaders();
        this.additionalProxyRequestHeaders = additionalProxyRequestHeaders != null ? additionalProxyRequestHeaders : new HttpHeaders();
        this.removeProxyRequestHeaders = removeProxyRequestHeaders != null ? List.copyOf(removeProxyRequestHeaders) : List.of();
        this.fixedDelayMilliseconds = fixedDelayMilliseconds;
        this.delayDistribution = delayDistribution;
        this.chunkedDribbleDelay = chunkedDribbleDelay;
        this.proxyBaseUrl = proxyBaseUrl == null ? null : proxyBaseUrl.trim();
        this.proxyUrlPrefixToRemove = proxyUrlPrefixToRemove;
        this.fault = fault;
        this.transformers = transformers != null ? List.copyOf(transformers) : List.of();
        this.transformerParameters = transformerParameters != null ? transformerParameters : Parameters.empty();
        this.browserProxyUrl = browserProxyUrl;
        this.wasConfigured = wasConfigured == null || wasConfigured != false;
    }

    public static ResponseDefinition notFound() {
        return new Builder().setStatus(404).build();
    }

    public static ResponseDefinition ok() {
        return new Builder().setStatus(200).build();
    }

    public static ResponseDefinition okEmptyJson() {
        return ResponseDefinitionBuilder.okForEmptyJson().build();
    }

    public static <T> ResponseDefinition okForJson(T body) {
        return ResponseDefinitionBuilder.okForJson(body).build();
    }

    public static ResponseDefinition created() {
        return new Builder().setStatus(201).build();
    }

    public static ResponseDefinition noContent() {
        return new Builder().setStatus(204).build();
    }

    public static ResponseDefinition badRequest(Errors errors) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(400).withHeader("Content-Type", "application/json").withBody(Json.write(errors)).build();
    }

    public static ResponseDefinition badRequestEntity(Errors errors) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(422).withHeader("Content-Type", "application/json").withBody(Json.write(errors)).build();
    }

    public static ResponseDefinition redirectTo(String path) {
        return new ResponseDefinitionBuilder().withHeader("Location", path).withStatus(302).build();
    }

    public static ResponseDefinition notConfigured() {
        return new Builder().setStatus(404).setWasConfigured(false).build();
    }

    public static ResponseDefinition notAuthorised() {
        return new Builder().setStatus(401).build();
    }

    public static ResponseDefinition notPermitted(String message) {
        return ResponseDefinition.notPermitted(Errors.single(40, message));
    }

    public static ResponseDefinition notPermitted(Errors errors) {
        return ResponseDefinitionBuilder.jsonResponse(errors, 403);
    }

    public static ResponseDefinition serverError() {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(500).build();
    }

    public static ResponseDefinition browserProxy(Request originalRequest) {
        return new Builder().setBrowserProxyUrl(originalRequest.getTypedAbsoluteUrl()).build();
    }

    public static ResponseDefinition copyOf(ResponseDefinition original) {
        return original.copy();
    }

    public ResponseDefinition copy() {
        return new ResponseDefinition(this.status, this.statusMessage, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.proxyUrlPrefixToRemove, this.fault, this.transformers, this.transformerParameters, this.browserProxyUrl, this.wasConfigured);
    }

    public ResponseDefinition transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull HttpHeaders getHeaders() {
        return this.headers;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull HttpHeaders getAdditionalProxyRequestHeaders() {
        return this.additionalProxyRequestHeaders;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull List<String> getRemoveProxyRequestHeaders() {
        return this.removeProxyRequestHeaders;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getBody() {
        return !this.body.isBinary() && !this.body.isJson() ? this.body.asString() : null;
    }

    @JsonIgnore
    public String getTextBody() {
        return !this.body.isBinary() ? this.body.asString() : null;
    }

    @JsonIgnore
    public byte[] getByteBody() {
        return this.body.asBytes();
    }

    @JsonIgnore
    public byte[] getByteBodyIfBinary() {
        return this.body.isBinary() ? this.body.asBytes() : null;
    }

    public String getBase64Body() {
        return this.body.isBinary() ? this.body.asBase64() : null;
    }

    @JsonIgnore
    public Body getReponseBody() {
        return this.body;
    }

    public JsonNode getJsonBody() {
        return this.body.isJson() ? this.body.asJson() : null;
    }

    public String getBodyFileName() {
        return this.bodyFileName;
    }

    public boolean wasConfigured() {
        return this.wasConfigured == null || this.wasConfigured != false;
    }

    public Boolean isFromConfiguredStub() {
        return this.wasConfigured == null || this.wasConfigured != false ? null : Boolean.valueOf(false);
    }

    public Integer getFixedDelayMilliseconds() {
        return this.fixedDelayMilliseconds;
    }

    public DelayDistribution getDelayDistribution() {
        return this.delayDistribution;
    }

    public ChunkedDribbleDelay getChunkedDribbleDelay() {
        return this.chunkedDribbleDelay;
    }

    public @Nullable String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public @Nullable Path getProxyUrlPrefixToRemove() {
        return this.proxyUrlPrefixToRemove;
    }

    @JsonIgnore
    public boolean specifiesBodyFile() {
        return this.bodyFileName != null && this.body.isAbsent();
    }

    @JsonIgnore
    public boolean specifiesBodyContent() {
        return this.body.isPresent();
    }

    @JsonIgnore
    public boolean specifiesTextBodyContent() {
        return this.body.isPresent() && !this.body.isBinary();
    }

    @JsonIgnore
    public boolean specifiesBinaryBodyContent() {
        return this.body.isPresent() && this.body.isBinary();
    }

    @JsonIgnore
    public boolean isProxyResponse() {
        return this.browserProxyUrl != null || this.proxyBaseUrl != null;
    }

    @JsonIgnore
    public @Nullable AbsoluteUrl getBrowserProxyUrl() {
        return this.browserProxyUrl;
    }

    public Fault getFault() {
        return this.fault;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull List<String> getTransformers() {
        return this.transformers;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull Parameters getTransformerParameters() {
        return this.transformerParameters;
    }

    public boolean hasTransformer(Extension transformer) {
        return this.transformers.contains(transformer.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseDefinition that = (ResponseDefinition)o;
        return this.status == that.status && Objects.equals(this.statusMessage, that.statusMessage) && Objects.equals(this.body, that.body) && Objects.equals(this.bodyFileName, that.bodyFileName) && Objects.equals(this.headers, that.headers) && Objects.equals(this.additionalProxyRequestHeaders, that.additionalProxyRequestHeaders) && Objects.equals(this.removeProxyRequestHeaders, that.removeProxyRequestHeaders) && Objects.equals(this.fixedDelayMilliseconds, that.fixedDelayMilliseconds) && Objects.equals(this.delayDistribution, that.delayDistribution) && Objects.equals(this.chunkedDribbleDelay, that.chunkedDribbleDelay) && Objects.equals(this.proxyBaseUrl, that.proxyBaseUrl) && Objects.equals(this.proxyUrlPrefixToRemove, that.proxyUrlPrefixToRemove) && this.fault == that.fault && Objects.equals(this.transformers, that.transformers) && Objects.equals(this.transformerParameters, that.transformerParameters) && Objects.equals(this.browserProxyUrl, that.browserProxyUrl) && Objects.equals(this.wasConfigured, that.wasConfigured);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.statusMessage, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.proxyUrlPrefixToRemove, this.fault, this.transformers, this.transformerParameters, this.browserProxyUrl, this.wasConfigured});
    }

    public String toString() {
        return this.wasConfigured != false ? Json.write(this) : "(no response definition configured)";
    }

    public static class Builder {
        private int status = 200;
        private String statusMessage;
        private Body body = Body.none();
        private String bodyFileName;
        private @NonNull HttpHeaders headers = new HttpHeaders();
        private @NonNull HttpHeaders additionalProxyRequestHeaders = new HttpHeaders();
        private @NonNull List<String> removeProxyRequestHeaders = new ArrayList<String>();
        private Integer fixedDelayMilliseconds;
        private DelayDistribution delayDistribution;
        private ChunkedDribbleDelay chunkedDribbleDelay;
        private @Nullable String proxyBaseUrl;
        private @Nullable Path proxyUrlPrefixToRemove = null;
        private Fault fault;
        private @NonNull List<String> transformers = new ArrayList<String>();
        private @NonNull Parameters transformerParameters = Parameters.empty();
        private @Nullable AbsoluteUrl browserProxyUrl;
        private Boolean wasConfigured = true;
        private Request originalRequest;

        public Builder() {
        }

        public Builder(ResponseDefinition original) {
            this.status = original.status;
            this.statusMessage = original.statusMessage;
            this.body = original.body;
            this.bodyFileName = original.bodyFileName;
            this.headers = original.headers;
            this.additionalProxyRequestHeaders = original.additionalProxyRequestHeaders;
            this.removeProxyRequestHeaders.addAll(original.removeProxyRequestHeaders);
            this.fixedDelayMilliseconds = original.fixedDelayMilliseconds;
            this.delayDistribution = original.delayDistribution;
            this.chunkedDribbleDelay = original.chunkedDribbleDelay;
            this.proxyBaseUrl = original.proxyBaseUrl;
            this.proxyUrlPrefixToRemove = original.proxyUrlPrefixToRemove;
            this.fault = original.fault;
            this.transformers.addAll(original.transformers);
            this.transformerParameters = original.transformerParameters;
            this.browserProxyUrl = original.browserProxyUrl;
            this.wasConfigured = original.wasConfigured;
        }

        public int getStatus() {
            return this.status;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public Body getBody() {
            return this.body;
        }

        public String getBodyFileName() {
            return this.bodyFileName;
        }

        public @NonNull HttpHeaders getHeaders() {
            return this.headers;
        }

        public @NonNull HttpHeaders getAdditionalProxyRequestHeaders() {
            return this.additionalProxyRequestHeaders;
        }

        public @NonNull List<String> getRemoveProxyRequestHeaders() {
            return this.removeProxyRequestHeaders;
        }

        public Integer getFixedDelayMilliseconds() {
            return this.fixedDelayMilliseconds;
        }

        public DelayDistribution getDelayDistribution() {
            return this.delayDistribution;
        }

        public ChunkedDribbleDelay getChunkedDribbleDelay() {
            return this.chunkedDribbleDelay;
        }

        public @Nullable String getProxyBaseUrl() {
            return this.proxyBaseUrl;
        }

        public @Nullable Path getProxyUrlPrefixToRemove() {
            return this.proxyUrlPrefixToRemove;
        }

        public Fault getFault() {
            return this.fault;
        }

        public @NonNull List<String> getTransformers() {
            return this.transformers;
        }

        public @NonNull Parameters getTransformerParameters() {
            return this.transformerParameters;
        }

        public @Nullable AbsoluteUrl getBrowserProxyUrl() {
            return this.browserProxyUrl;
        }

        public Boolean getWasConfigured() {
            return this.wasConfigured;
        }

        public Request getOriginalRequest() {
            return this.originalRequest;
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder setBody(Body body) {
            this.body = body;
            return this;
        }

        public Builder setBodyFileName(String bodyFileName) {
            this.bodyFileName = bodyFileName;
            return this;
        }

        public Builder setHeaders(@NonNull HttpHeaders headers) {
            Objects.requireNonNull(headers);
            this.headers = headers;
            return this;
        }

        public Builder headers(Consumer<HttpHeaders.Builder> transformer) {
            this.headers = this.headers.transform(transformer);
            return this;
        }

        public Builder setAdditionalProxyRequestHeaders(@NonNull HttpHeaders additionalProxyRequestHeaders) {
            Objects.requireNonNull(additionalProxyRequestHeaders);
            this.additionalProxyRequestHeaders = additionalProxyRequestHeaders;
            return this;
        }

        public Builder setRemoveProxyRequestHeaders(@NonNull List<String> removeProxyRequestHeaders) {
            Objects.requireNonNull(removeProxyRequestHeaders);
            this.removeProxyRequestHeaders = removeProxyRequestHeaders;
            return this;
        }

        public Builder setFixedDelayMilliseconds(Integer fixedDelayMilliseconds) {
            this.fixedDelayMilliseconds = fixedDelayMilliseconds;
            return this;
        }

        public Builder setDelayDistribution(DelayDistribution delayDistribution) {
            this.delayDistribution = delayDistribution;
            return this;
        }

        public Builder setChunkedDribbleDelay(ChunkedDribbleDelay chunkedDribbleDelay) {
            this.chunkedDribbleDelay = chunkedDribbleDelay;
            return this;
        }

        public Builder setProxyBaseUrl(AbsoluteUrl proxyBaseUrl) {
            this.proxyBaseUrl = proxyBaseUrl.toString();
            return this;
        }

        public Builder setProxyBaseUrl(String proxyBaseUrl) {
            this.proxyBaseUrl = proxyBaseUrl;
            return this;
        }

        public Builder setProxyUrlPrefixToRemove(@Nullable String proxyUrlPrefixToRemove) {
            Path prefix = proxyUrlPrefixToRemove != null ? Path.parse((String)proxyUrlPrefixToRemove) : null;
            return this.setProxyUrlPrefixToRemove(prefix);
        }

        public Builder setProxyUrlPrefixToRemove(@Nullable Path proxyUrlPrefixToRemove) {
            this.proxyUrlPrefixToRemove = proxyUrlPrefixToRemove;
            return this;
        }

        public Builder setFault(Fault fault) {
            this.fault = fault;
            return this;
        }

        public Builder setTransformers(@NonNull List<String> transformers) {
            Objects.requireNonNull(transformers);
            this.transformers = transformers;
            return this;
        }

        public Builder setTransformerParameters(@NonNull Parameters transformerParameters) {
            Objects.requireNonNull(transformerParameters);
            this.transformerParameters = transformerParameters;
            return this;
        }

        public Builder setBrowserProxyUrl(@Nullable AbsoluteUrl browserProxyUrl) {
            this.browserProxyUrl = browserProxyUrl;
            return this;
        }

        public Builder setBrowserProxyUrl(@Nullable String browserProxyUrl) {
            AbsoluteUrl url = browserProxyUrl != null ? AbsoluteUrl.parse((String)browserProxyUrl) : null;
            return this.setBrowserProxyUrl(url);
        }

        public Builder setWasConfigured(Boolean wasConfigured) {
            this.wasConfigured = wasConfigured;
            return this;
        }

        public Builder setOriginalRequest(Request originalRequest) {
            this.originalRequest = originalRequest;
            return this;
        }

        public ResponseDefinition build() {
            return new ResponseDefinition(this.status, this.statusMessage, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.proxyUrlPrefixToRemove, this.fault, this.transformers, this.transformerParameters, this.browserProxyUrl, this.wasConfigured);
        }
    }
}

