/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.PathAndQuery;
import org.wiremock.url.Query;

public interface Request {
    @JsonIgnore
    default public UUID getId() {
        return null;
    }

    @Deprecated
    public @NonNull String getUrl();

    @JsonIgnore
    default public @NonNull PathAndQuery getPathAndQueryWithoutPrefix() {
        return PathAndQuery.parse((String)this.getUrl());
    }

    @Deprecated
    public @Nullable String getAbsoluteUrl();

    @JsonIgnore
    default public @Nullable AbsoluteUrl getTypedAbsoluteUrl() {
        String absoluteUrl = this.getAbsoluteUrl();
        return absoluteUrl != null ? AbsoluteUrl.parse((String)absoluteUrl) : null;
    }

    public RequestMethod getMethod();

    public String getScheme();

    public String getHost();

    public int getPort();

    public String getClientIp();

    public String getHeader(String var1);

    public HttpHeader header(String var1);

    public ContentTypeHeader contentTypeHeader();

    public HttpHeaders getHeaders();

    public boolean containsHeader(String var1);

    public Set<String> getAllHeaderKeys();

    @JsonIgnore
    default public PathParams getPathParameters() {
        return PathParams.empty();
    }

    @Deprecated
    default public @Nullable QueryParameter queryParameter(String key) {
        PathAndQuery pathAndQuery = this.getPathAndQueryWithoutPrefix();
        Query query = pathAndQuery.getQueryOrEmpty();
        return new QueryParameter(key, query.getDecoded(key));
    }

    public FormParameter formParameter(String var1);

    public Map<String, FormParameter> formParameters();

    public Map<String, Cookie> getCookies();

    public byte[] getBody();

    public String getBodyAsString();

    public String getBodyAsBase64();

    public boolean isMultipart();

    public Collection<Part> getParts();

    public Part getPart(String var1);

    public boolean isBrowserProxyRequest();

    public Optional<Request> getOriginalRequest();

    public String getProtocol();

    public static interface Part {
        public String getName();

        public String getFileName();

        public HttpHeader getHeader(String var1);

        public HttpHeaders getHeaders();

        public Body getBody();
    }
}

