/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.global;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class GlobalSettings {
    private final @Nullable Integer fixedDelay;
    private final @Nullable DelayDistribution delayDistribution;
    private final @Nullable Parameters extended;
    private final boolean proxyPassThrough;

    public static Builder builder() {
        return new Builder();
    }

    public static GlobalSettings defaults() {
        return new Builder().build();
    }

    public GlobalSettings(@JsonProperty(value="fixedDelay") @Nullable Integer fixedDelay, @JsonProperty(value="delayDistribution") @Nullable DelayDistribution delayDistribution, @JsonProperty(value="extended") @Nullable Parameters extended, @JsonProperty(value="proxyPassThrough") boolean proxyPassThrough) {
        this.fixedDelay = fixedDelay;
        this.delayDistribution = delayDistribution;
        this.extended = extended;
        this.proxyPassThrough = proxyPassThrough;
    }

    public @Nullable Integer getFixedDelay() {
        return this.fixedDelay;
    }

    public @Nullable DelayDistribution getDelayDistribution() {
        return this.delayDistribution;
    }

    public @Nullable Parameters getExtended() {
        return this.extended;
    }

    public boolean getProxyPassThrough() {
        return this.proxyPassThrough;
    }

    public Builder copy() {
        return new Builder().fixedDelay(this.fixedDelay).delayDistribution(this.delayDistribution).extended(this.extended);
    }

    public GlobalSettings transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    private Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSettings that = (GlobalSettings)o;
        return Objects.equals(this.getFixedDelay(), that.getFixedDelay()) && Objects.equals(this.getDelayDistribution(), that.getDelayDistribution()) && Objects.equals(this.getExtended(), that.getExtended());
    }

    public int hashCode() {
        return Objects.hash(this.getFixedDelay(), this.getDelayDistribution(), this.getExtended());
    }

    public static class Builder {
        private @Nullable Integer fixedDelay;
        private @Nullable DelayDistribution delayDistribution;
        private @Nullable Parameters extended;
        private boolean proxyPassThrough = true;

        public Builder() {
        }

        public Builder(GlobalSettings existing) {
            this.fixedDelay = existing.getFixedDelay();
            this.delayDistribution = existing.getDelayDistribution();
            this.extended = existing.getExtended();
            this.proxyPassThrough = existing.getProxyPassThrough();
        }

        public Builder fixedDelay(@Nullable Integer fixedDelay) {
            this.fixedDelay = fixedDelay;
            return this;
        }

        public Builder delayDistribution(@Nullable DelayDistribution delayDistribution) {
            this.delayDistribution = delayDistribution;
            return this;
        }

        public Builder extended(@Nullable Parameters extended) {
            this.extended = extended;
            return this;
        }

        public Builder proxyPassThrough(boolean proxyPassThrough) {
            this.proxyPassThrough = proxyPassThrough;
            return this;
        }

        public @Nullable Integer getFixedDelay() {
            return this.fixedDelay;
        }

        public @Nullable DelayDistribution getDelayDistribution() {
            return this.delayDistribution;
        }

        public @Nullable Parameters getExtended() {
            return this.extended;
        }

        public boolean isProxyPassThrough() {
            return this.proxyPassThrough;
        }

        public Builder setFixedDelay(@Nullable Integer fixedDelay) {
            this.fixedDelay = fixedDelay;
            return this;
        }

        public Builder setDelayDistribution(@Nullable DelayDistribution delayDistribution) {
            this.delayDistribution = delayDistribution;
            return this;
        }

        public Builder setExtended(@Nullable Parameters extended) {
            this.extended = extended;
            return this;
        }

        public Builder setProxyPassThrough(boolean proxyPassThrough) {
            this.proxyPassThrough = proxyPassThrough;
            return this;
        }

        public GlobalSettings build() {
            return new GlobalSettings(this.fixedDelay, this.delayDistribution, this.extended, this.proxyPassThrough);
        }
    }
}

