/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HelperUtils;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

class JsonArrayAddHelper
extends HandlebarsHelper<Object> {
    private final ParseContext parseContext = JsonPath.using((Configuration)HelperUtils.jsonPathConfig);

    JsonArrayAddHelper() {
    }

    public String apply(Object inputJson, Options options) throws IOException {
        boolean flatten;
        Object toAdd;
        String itemToAddString;
        Object currentList;
        DocumentContext root;
        if (!(inputJson instanceof String)) {
            return this.handleError("Base JSON must be a string");
        }
        try {
            root = this.parseContext.parse((String)inputJson);
        }
        catch (Exception e) {
            return this.handleError("Base JSON is not valid JSON ('" + String.valueOf(inputJson) + "')", e);
        }
        Object jsonPathString = options.hash.get("jsonPath");
        if (jsonPathString != null && !(jsonPathString instanceof String)) {
            return this.handleError("jsonPath option must be a string");
        }
        if (jsonPathString == null) {
            currentList = root.json();
        } else {
            try {
                if (((String)jsonPathString).isEmpty()) {
                    throw new InvalidPathException("JSONPath expression is empty");
                }
                currentList = root.read((String)jsonPathString, new Predicate[0]);
            }
            catch (PathNotFoundException e) {
                currentList = null;
            }
            catch (InvalidPathException e) {
                return this.handleError("jsonPath option is not valid JSONPath expression ('" + String.valueOf(jsonPathString) + "')");
            }
        }
        if (!(currentList instanceof List)) {
            String detail = jsonPathString == null ? "'" + String.valueOf(inputJson) + "'" : "root: '" + String.valueOf(inputJson) + "', jsonPath: '" + String.valueOf(jsonPathString) + "'";
            return this.handleError("Target JSON is not a JSON array (" + detail + ")");
        }
        if (options.tagType == TagType.SECTION) {
            itemToAddString = options.fn().toString();
        } else {
            String string = itemToAddString = options.params.length > 0 ? options.params[0] : null;
        }
        if (!(itemToAddString instanceof String)) {
            return this.handleError("Item-to-add JSON must be a string");
        }
        try {
            toAdd = Json.read(itemToAddString, Object.class);
        }
        catch (Exception e) {
            return this.handleError("Item-to-add JSON is not valid JSON ('" + String.valueOf(itemToAddString) + "')", e);
        }
        Object flatten0 = options.hash.get("flatten");
        if (flatten0 instanceof Boolean) {
            flatten = (Boolean)flatten0;
        } else if (flatten0 == null) {
            flatten = false;
        } else {
            return this.handleError("flatten option must be a boolean");
        }
        if (flatten && toAdd instanceof Collection) {
            ((List)currentList).addAll((Collection)toAdd);
        } else {
            ((List)currentList).add(toAdd);
        }
        Object maxItems = options.hash.get("maxItems");
        if (maxItems != null) {
            if (!(maxItems instanceof Integer)) {
                return this.handleError("maxItems option must be an integer");
            }
            if ((Integer)maxItems < 0) {
                return this.handleError("maxItems option integer must be positive");
            }
            if (((List)currentList).size() - (Integer)maxItems > 0) {
                ((List)currentList).subList(0, ((List)currentList).size() - (Integer)maxItems).clear();
            }
        }
        return root.jsonString();
    }
}

