/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.AbstractArrayHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArrayAddHelper
extends AbstractArrayHelper {
    public Object apply(List<?> list, Options options) throws IOException {
        Integer position;
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList mutableList = new ArrayList(list);
        if (options.params.length == 0) {
            return this.handleError("Missing required parameter: additional value to add to list");
        }
        Object newValue = options.params[0];
        try {
            position = this.parsePosition(options);
        }
        catch (NumberFormatException e) {
            return this.handleError("position must be 'start', 'end' or an integer");
        }
        if (position != null) {
            if (position < 0 || position > mutableList.size()) {
                return this.handleError("position must be greater than or equal to 0 and less than or equal to the size of the list");
            }
            mutableList.add(position, newValue);
        } else {
            mutableList.add(newValue);
        }
        return mutableList;
    }
}

