/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.entity.EntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.StringEntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.TextEntityDefinition;
import com.github.tomakehurst.wiremock.extension.MessageActionTransformer;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageAction;
import com.github.tomakehurst.wiremock.message.MessageActionContext;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessageDefinition;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.message.SendMessageAction;
import java.util.HashMap;
import java.util.Map;

public class MessageTemplateTransformer
implements MessageActionTransformer {
    public static final String NAME = "message-template";
    private final TemplateEngine templateEngine;

    public MessageTemplateTransformer(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean applyGlobally() {
        return true;
    }

    @Override
    public MessageAction transform(MessageAction action, MessageActionContext context) {
        if (!(action instanceof SendMessageAction)) {
            return action;
        }
        SendMessageAction sendAction = (SendMessageAction)action;
        EntityDefinition body = sendAction.getBody();
        if (body == null) {
            return action;
        }
        String bodyContent = this.extractBodyContent(body);
        if (bodyContent == null || bodyContent.isEmpty()) {
            return action;
        }
        Map<String, Object> model = this.buildModel(context, sendAction);
        HandlebarsOptimizedTemplate template = this.templateEngine.getTemplate(bodyContent, bodyContent);
        String transformedBody = template.apply(model);
        return this.rebuildAction(sendAction, transformedBody);
    }

    private String extractBodyContent(EntityDefinition body) {
        if (body instanceof StringEntityDefinition) {
            StringEntityDefinition stringDef = (StringEntityDefinition)body;
            return stringDef.getValue();
        }
        if (body instanceof TextEntityDefinition) {
            TextEntityDefinition textDef = (TextEntityDefinition)body;
            Object data = textDef.getData();
            if (data instanceof String) {
                return (String)data;
            }
            if (data != null) {
                return Json.write(data);
            }
        }
        return null;
    }

    private Map<String, Object> buildModel(MessageActionContext context, SendMessageAction action) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (context.isTriggeredByMessage()) {
            Request initiatingRequest;
            MessageChannel channel;
            Message incomingMessage = context.getIncomingMessage();
            if (incomingMessage != null) {
                model.put("message", new MessageTemplateModel(incomingMessage));
            }
            if ((channel = context.getOriginatingChannel()) instanceof RequestInitiatedMessageChannel && (initiatingRequest = ((RequestInitiatedMessageChannel)channel).getInitiatingRequest()) != null) {
                model.putAll(this.templateEngine.buildModelForRequest(initiatingRequest));
            }
        } else if (context.isTriggeredByHttp()) {
            model.putAll(this.templateEngine.buildModelForRequest(context.getHttpServeEvent()));
        }
        Parameters params = action.getTransformerParameters();
        if (params != null && !params.isEmpty()) {
            model.put("parameters", params);
        }
        return model;
    }

    private SendMessageAction rebuildAction(SendMessageAction original, String newBody) {
        return new SendMessageAction(new MessageDefinition(new StringEntityDefinition(newBody)), original.getChannelTarget(), original.getTransformers(), original.getTransformerParameters());
    }

    public static class MessageTemplateModel {
        private final String body;

        public MessageTemplateModel(Message message) {
            this.body = message != null ? message.getBodyAsString() : null;
        }

        public String getBody() {
            return this.body;
        }
    }
}

