/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public class EncodingType {
    public static final EncodingType TEXT = new EncodingType("text");
    public static final EncodingType BINARY = new EncodingType("binary");
    public static final EncodingType MULTIPART = new EncodingType("multipart");
    private final String type;

    public EncodingType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static EncodingType fromString(String value) {
        return new EncodingType(value);
    }

    @JsonValue
    public String value() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingType that = (EncodingType)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.type;
    }

    public static EncodingType[] values() {
        return new EncodingType[]{TEXT, BINARY, MULTIPART};
    }
}

