/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Strings;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.IllegalUri;
import org.wiremock.url.Password;
import org.wiremock.url.SchemeRegistry;

public class ProxySettings {
    public static final ProxySettings NO_PROXY = new ProxySettings(null, 0);
    public static final int DEFAULT_PORT = 80;
    private final String host;
    private final int port;
    private String username;
    private String password;

    public ProxySettings(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static ProxySettings fromString(String config) {
        try {
            AbsoluteUrl proxyUrl;
            try {
                proxyUrl = AbsoluteUrl.parse((String)config);
            }
            catch (IllegalUri e) {
                config = "http://" + (String)config;
                proxyUrl = AbsoluteUrl.parse((String)config);
            }
            if (!proxyUrl.getScheme().equals(SchemeRegistry.http)) {
                throw new IllegalArgumentException("Proxy via does not support any other protocol than http");
            }
            ParameterUtils.checkParameter(!proxyUrl.getHost().isEmpty(), "Host part of proxy must be specified");
            ProxySettings proxySettings = new ProxySettings(proxyUrl.getHost().toString(), proxyUrl.getResolvedPort().getIntValue());
            if (proxyUrl.getUserInfo() != null) {
                proxySettings.setUsername(proxyUrl.getUserInfo().getUsername().toString());
                Password password = proxyUrl.getUserInfo().getPassword();
                if (password != null) {
                    proxySettings.setPassword(password.toString());
                }
            }
            return proxySettings;
        }
        catch (IllegalUri e) {
            throw new IllegalArgumentException(String.format("Proxy via Url %s was not recognized", config), e);
        }
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        if (this == NO_PROXY) {
            return "(no proxy)";
        }
        return String.format("%s:%s%s", this.host(), this.port(), Strings.isNotEmpty(this.username) ? " (with credentials)" : "");
    }
}

