/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.message.ChannelType;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessageStubMapping;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.common.base.Stopwatch;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class MessageServeEvent {
    private final UUID id;
    private final EventType eventType;
    private final ChannelType channelType;
    private final UUID channelId;
    private final LoggedRequest channelRequest;
    private final Message message;
    private final MessageStubMapping stubMapping;
    private final boolean wasMatched;
    private final Instant timestamp;
    private final ConcurrentLinkedQueue<SubEvent> subEvents;
    private final Stopwatch stopwatch;

    @JsonCreator
    public MessageServeEvent(@JsonProperty(value="id") UUID id, @JsonProperty(value="eventType") EventType eventType, @JsonProperty(value="channelType") ChannelType channelType, @JsonProperty(value="channelId") UUID channelId, @JsonProperty(value="channelRequest") LoggedRequest channelRequest, @JsonProperty(value="message") Message message, @JsonProperty(value="stubMapping") MessageStubMapping stubMapping, @JsonProperty(value="wasMatched") boolean wasMatched, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="subEvents") Queue<SubEvent> subEvents) {
        this.id = id != null ? id : UUID.randomUUID();
        this.eventType = eventType;
        this.channelType = channelType;
        this.channelId = channelId;
        this.channelRequest = channelRequest;
        this.message = message;
        this.stubMapping = stubMapping;
        this.wasMatched = wasMatched;
        this.timestamp = timestamp != null ? timestamp : Instant.now();
        this.subEvents = subEvents != null ? new ConcurrentLinkedQueue<SubEvent>(subEvents) : new ConcurrentLinkedQueue();
        this.stopwatch = Stopwatch.createStarted();
    }

    private MessageServeEvent(UUID id, EventType eventType, ChannelType channelType, UUID channelId, LoggedRequest channelRequest, Message message, MessageStubMapping stubMapping, boolean wasMatched, Instant timestamp, ConcurrentLinkedQueue<SubEvent> subEvents, Stopwatch stopwatch) {
        this.id = id;
        this.eventType = eventType;
        this.channelType = channelType;
        this.channelId = channelId;
        this.channelRequest = channelRequest;
        this.message = message;
        this.stubMapping = stubMapping;
        this.wasMatched = wasMatched;
        this.timestamp = timestamp;
        this.subEvents = subEvents;
        this.stopwatch = stopwatch;
    }

    public static MessageServeEvent receivedMatched(ChannelType channelType, UUID channelId, Request channelRequest, Message message, MessageStubMapping stubMapping) {
        return new MessageServeEvent(UUID.randomUUID(), EventType.RECEIVED, channelType, channelId, LoggedRequest.createFrom(channelRequest), message, stubMapping, true, Instant.now(), null);
    }

    public static MessageServeEvent receivedMatched(MessageChannel channel, Message message, MessageStubMapping stubMapping) {
        Request channelRequest = null;
        if (channel instanceof RequestInitiatedMessageChannel) {
            channelRequest = ((RequestInitiatedMessageChannel)channel).getInitiatingRequest();
        }
        return MessageServeEvent.receivedMatched(channel.getType(), channel.getId(), channelRequest, message, stubMapping);
    }

    public static MessageServeEvent receivedUnmatched(ChannelType channelType, UUID channelId, Request channelRequest, Message message) {
        return new MessageServeEvent(UUID.randomUUID(), EventType.RECEIVED, channelType, channelId, LoggedRequest.createFrom(channelRequest), message, null, false, Instant.now(), null);
    }

    public static MessageServeEvent receivedUnmatched(MessageChannel channel, Message message) {
        Request channelRequest = null;
        if (channel instanceof RequestInitiatedMessageChannel) {
            channelRequest = ((RequestInitiatedMessageChannel)channel).getInitiatingRequest();
        }
        return MessageServeEvent.receivedUnmatched(channel.getType(), channel.getId(), channelRequest, message);
    }

    public static MessageServeEvent sent(ChannelType channelType, UUID channelId, Request channelRequest, Message message) {
        return new MessageServeEvent(UUID.randomUUID(), EventType.SENT, channelType, channelId, LoggedRequest.createFrom(channelRequest), message, null, true, Instant.now(), null);
    }

    public static MessageServeEvent sent(MessageChannel channel, Message message) {
        Request channelRequest = null;
        if (channel instanceof RequestInitiatedMessageChannel) {
            channelRequest = ((RequestInitiatedMessageChannel)channel).getInitiatingRequest();
        }
        return MessageServeEvent.sent(channel.getType(), channel.getId(), channelRequest, message);
    }

    public UUID getId() {
        return this.id;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public UUID getChannelId() {
        return this.channelId;
    }

    public LoggedRequest getChannelRequest() {
        return this.channelRequest;
    }

    public Message getMessage() {
        return this.message;
    }

    public MessageStubMapping getStubMapping() {
        return this.stubMapping;
    }

    public boolean getWasMatched() {
        return this.wasMatched;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Queue<? extends SubEvent> getSubEvents() {
        return this.subEvents;
    }

    @JsonIgnore
    public boolean isReceived() {
        return this.eventType == EventType.RECEIVED;
    }

    @JsonIgnore
    public boolean isSent() {
        return this.eventType == EventType.SENT;
    }

    public void appendSubEvent(String type, Object data) {
        long elapsedNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.appendSubEvent(new SubEvent(type, (Long)elapsedNanos, data));
    }

    public void appendSubEvent(SubEvent subEvent) {
        this.subEvents.add(subEvent);
    }

    public MessageServeEvent withStubMapping(MessageStubMapping stubMapping) {
        return new MessageServeEvent(this.id, this.eventType, this.channelType, this.channelId, this.channelRequest, this.message, stubMapping, stubMapping != null, this.timestamp, this.subEvents, this.stopwatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MessageServeEvent create(Consumer<Builder> transformer) {
        Builder builder = MessageServeEvent.builder();
        transformer.accept(builder);
        return builder.build();
    }

    public MessageServeEvent transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageServeEvent that = (MessageServeEvent)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static enum EventType {
        RECEIVED,
        SENT;


        @JsonValue
        public String toJson() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @JsonCreator
        public static EventType fromJson(String value) {
            if (value == null) {
                return null;
            }
            return EventType.valueOf(value.toUpperCase(Locale.ROOT));
        }
    }

    public static class Builder {
        private UUID id;
        private EventType eventType;
        private ChannelType channelType;
        private UUID channelId;
        private LoggedRequest channelRequest;
        private Message message;
        private MessageStubMapping stubMapping;
        private boolean wasMatched;
        private Instant timestamp;
        private Queue<SubEvent> subEvents;

        public Builder() {
        }

        public Builder(MessageServeEvent existing) {
            this.id = existing.id;
            this.eventType = existing.eventType;
            this.channelType = existing.channelType;
            this.channelId = existing.channelId;
            this.channelRequest = existing.channelRequest;
            this.message = existing.message;
            this.stubMapping = existing.stubMapping;
            this.wasMatched = existing.wasMatched;
            this.timestamp = existing.timestamp;
            this.subEvents = new ConcurrentLinkedQueue<SubEvent>(existing.subEvents);
        }

        public Builder withId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder withEventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder withChannelType(ChannelType channelType) {
            this.channelType = channelType;
            return this;
        }

        public Builder withChannelId(UUID channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder withChannelRequest(LoggedRequest channelRequest) {
            this.channelRequest = channelRequest;
            return this;
        }

        public Builder withMessage(Message message) {
            this.message = message;
            return this;
        }

        public Builder withStubMapping(MessageStubMapping stubMapping) {
            this.stubMapping = stubMapping;
            return this;
        }

        public Builder withWasMatched(boolean wasMatched) {
            this.wasMatched = wasMatched;
            return this;
        }

        public Builder withTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withSubEvents(Queue<SubEvent> subEvents) {
            this.subEvents = subEvents;
            return this;
        }

        public MessageServeEvent build() {
            return new MessageServeEvent(this.id, this.eventType, this.channelType, this.channelId, this.channelRequest, this.message, this.stubMapping, this.wasMatched, this.timestamp, this.subEvents);
        }
    }
}

