/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.store.MessageJournalStore;
import com.github.tomakehurst.wiremock.store.StoreEvent;
import com.github.tomakehurst.wiremock.verification.MessageServeEvent;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class InMemoryMessageJournalStore
implements MessageJournalStore {
    private final Deque<UUID> deque = new ConcurrentLinkedDeque<UUID>();
    private final Map<UUID, MessageServeEvent> events = new ConcurrentHashMap<UUID, MessageServeEvent>();
    private final List<Consumer<? super StoreEvent<UUID, MessageServeEvent>>> eventListeners = new CopyOnWriteArrayList<Consumer<? super StoreEvent<UUID, MessageServeEvent>>>();

    @Override
    public void add(MessageServeEvent event) {
        MessageServeEvent previous = this.events.put(event.getId(), event);
        this.deque.addFirst(event.getId());
        this.notifyListeners(new StoreEvent<UUID, MessageServeEvent>(event.getId(), previous, event));
    }

    @Override
    public Stream<MessageServeEvent> getAll() {
        return this.deque.stream().map(this.events::get).filter(Objects::nonNull);
    }

    @Override
    public void removeLast() {
        MessageServeEvent removed;
        UUID id = this.deque.pollLast();
        if (id != null && (removed = this.events.remove(id)) != null) {
            this.notifyListeners(new StoreEvent<UUID, Object>(id, removed, null));
        }
    }

    @Override
    public Stream<UUID> getAllKeys() {
        return this.getAll().map(MessageServeEvent::getId);
    }

    @Override
    public Optional<MessageServeEvent> get(UUID id) {
        return Optional.ofNullable(this.events.get(id));
    }

    @Override
    public void put(UUID id, MessageServeEvent event) {
        if (this.deque.contains(id)) {
            MessageServeEvent previous = this.events.put(id, event);
            this.notifyListeners(new StoreEvent<UUID, MessageServeEvent>(id, previous, event));
        }
    }

    @Override
    public void remove(UUID id) {
        this.deque.stream().filter(eventId -> eventId.equals(id)).forEach(this.deque::remove);
        MessageServeEvent removed = this.events.remove(id);
        if (removed != null) {
            this.notifyListeners(new StoreEvent<UUID, Object>(id, removed, null));
        }
    }

    @Override
    public void clear() {
        this.deque.clear();
        this.events.clear();
    }

    @Override
    public void registerEventListener(Consumer<? super StoreEvent<UUID, MessageServeEvent>> listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void unregisterEventListener(Consumer<? super StoreEvent<UUID, MessageServeEvent>> listener) {
        this.eventListeners.remove(listener);
    }

    private void notifyListeners(StoreEvent<UUID, MessageServeEvent> event) {
        for (Consumer<? super StoreEvent<UUID, MessageServeEvent>> listener : this.eventListeners) {
            try {
                listener.accept(event);
            }
            catch (Exception exception) {}
        }
    }
}

