/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.message.ChannelType;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessageDefinition;
import com.github.tomakehurst.wiremock.message.MessageStubRequestHandler;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.store.MessageChannelStore;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class MessageChannels {
    private final MessageChannelStore store;

    public MessageChannels(MessageChannelStore store) {
        this.store = store;
    }

    public void add(MessageChannel channel) {
        this.store.add(channel);
    }

    public void remove(UUID id) {
        this.store.remove(id).ifPresent(MessageChannel::close);
    }

    public Optional<MessageChannel> get(UUID id) {
        return this.store.get(id);
    }

    public List<MessageChannel> getAll() {
        return this.store.getAll().collect(Collectors.toList());
    }

    public List<MessageChannel> getAllByType(ChannelType type) {
        return this.store.getAll().filter(channel -> channel.getType() == type).collect(Collectors.toList());
    }

    public List<MessageChannel> getAllOpen() {
        return this.store.getAll().filter(MessageChannel::isOpen).collect(Collectors.toList());
    }

    public List<MessageChannel> getAllOpenByType(ChannelType type) {
        return this.store.getAll().filter(MessageChannel::isOpen).filter(channel -> channel.getType() == type).collect(Collectors.toList());
    }

    public List<RequestInitiatedMessageChannel> findByRequestPattern(RequestPattern requestPattern, Map<String, RequestMatcherExtension> customMatchers) {
        return this.store.getAll().filter(MessageChannel::isOpen).filter(RequestInitiatedMessageChannel.class::isInstance).map(RequestInitiatedMessageChannel.class::cast).filter(channel -> requestPattern.match(channel.getInitiatingRequest(), customMatchers).isExactMatch()).collect(Collectors.toList());
    }

    public List<RequestInitiatedMessageChannel> findByTypeAndRequestPattern(ChannelType type, RequestPattern requestPattern, Map<String, RequestMatcherExtension> customMatchers) {
        return this.store.getAll().filter(MessageChannel::isOpen).filter(channel -> channel.getType() == type).filter(RequestInitiatedMessageChannel.class::isInstance).map(RequestInitiatedMessageChannel.class::cast).filter(channel -> requestPattern.match(channel.getInitiatingRequest(), customMatchers).isExactMatch()).collect(Collectors.toList());
    }

    public int sendMessageToMatching(RequestPattern requestPattern, MessageDefinition messageDefinition, Map<String, RequestMatcherExtension> customMatchers) {
        List<RequestInitiatedMessageChannel> matchingChannels = this.findByRequestPattern(requestPattern, customMatchers);
        Message message = MessageStubRequestHandler.resolveToMessage(messageDefinition, null);
        for (RequestInitiatedMessageChannel channel : matchingChannels) {
            channel.sendMessage(message);
        }
        return matchingChannels.size();
    }

    public List<RequestInitiatedMessageChannel> sendMessageToMatchingByType(ChannelType type, RequestPattern requestPattern, MessageDefinition messageDefinition, Map<String, RequestMatcherExtension> customMatchers) {
        List<RequestInitiatedMessageChannel> matchingChannels = this.findByTypeAndRequestPattern(type, requestPattern, customMatchers);
        Message message = MessageStubRequestHandler.resolveToMessage(messageDefinition, null);
        for (RequestInitiatedMessageChannel channel : matchingChannels) {
            channel.sendMessage(message);
        }
        return matchingChannels;
    }

    public int size() {
        return (int)this.store.getAll().count();
    }

    public int sizeByType(ChannelType type) {
        return (int)this.store.getAll().filter(channel -> channel.getType() == type).count();
    }

    public int openCount() {
        return (int)this.store.getAll().filter(MessageChannel::isOpen).count();
    }

    public int openCountByType(ChannelType type) {
        return (int)this.store.getAll().filter(MessageChannel::isOpen).filter(channel -> channel.getType() == type).count();
    }
}

