/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessageStubMapping;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;

public class MessageActionContext {
    private final MessageStubMapping stubMapping;
    private final MessageChannel originatingChannel;
    private final Message incomingMessage;
    private final ServeEvent httpServeEvent;

    private MessageActionContext(MessageStubMapping stubMapping, MessageChannel originatingChannel, Message incomingMessage, ServeEvent httpServeEvent) {
        this.stubMapping = stubMapping;
        this.originatingChannel = originatingChannel;
        this.incomingMessage = incomingMessage;
        this.httpServeEvent = httpServeEvent;
    }

    public static MessageActionContext forIncomingMessage(MessageStubMapping stubMapping, MessageChannel originatingChannel, Message incomingMessage) {
        return new MessageActionContext(stubMapping, originatingChannel, incomingMessage, null);
    }

    public static MessageActionContext forHttpTrigger(MessageStubMapping stubMapping, ServeEvent httpServeEvent) {
        return new MessageActionContext(stubMapping, null, null, httpServeEvent);
    }

    public MessageStubMapping getStubMapping() {
        return this.stubMapping;
    }

    public MessageChannel getOriginatingChannel() {
        return this.originatingChannel;
    }

    public Message getIncomingMessage() {
        return this.incomingMessage;
    }

    public ServeEvent getHttpServeEvent() {
        return this.httpServeEvent;
    }

    public boolean isTriggeredByMessage() {
        return this.originatingChannel != null;
    }

    public boolean isTriggeredByHttp() {
        return this.httpServeEvent != null;
    }
}

