/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.common.InputStreamSource;
import com.github.tomakehurst.wiremock.common.entity.CompressionType;
import com.github.tomakehurst.wiremock.common.entity.EncodingType;
import com.github.tomakehurst.wiremock.common.entity.Entity;
import com.github.tomakehurst.wiremock.common.entity.FormatType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@JsonDeserialize(using=MessageDeserializer.class)
public class Message {
    private final Entity body;

    public Message(Entity body) {
        this.body = body;
    }

    @JsonIgnore
    public Entity getBody() {
        return this.body;
    }

    @JsonIgnore
    public byte[] getBodyAsBytes() {
        if (this.body == null) {
            return null;
        }
        return this.body.getData();
    }

    @JsonValue
    public String getBodyAsString() {
        if (this.body == null) {
            return null;
        }
        byte[] data = this.body.getData();
        return data != null ? new String(data, StandardCharsets.UTF_8) : null;
    }

    @JsonIgnore
    public boolean isBinary() {
        return this.body != null && EncodingType.BINARY.equals(this.body.getEncoding());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.body, message.body);
    }

    public int hashCode() {
        return Objects.hashCode(this.body);
    }

    public String toString() {
        return this.getBodyAsString();
    }

    static class MessageDeserializer
    extends JsonDeserializer<Message> {
        MessageDeserializer() {
        }

        public Message deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String text = p.getValueAsString();
            if (text == null) {
                return new Message(null);
            }
            byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
            InputStreamSource streamSource = () -> new ByteArrayInputStream(bytes);
            Entity entity = new Entity(EncodingType.TEXT, FormatType.TEXT, CompressionType.NONE, streamSource);
            return new Message(entity);
        }
    }
}

