/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.PathAndQuery;

public class RequestIdDecorator
implements Request {
    private final Request request;
    private final UUID id;

    public RequestIdDecorator(Request request, UUID id) {
        this.request = request;
        this.id = id;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public @NonNull String getUrl() {
        return this.request.getUrl();
    }

    @Override
    public @NonNull PathAndQuery getPathAndQueryWithoutPrefix() {
        return this.request.getPathAndQueryWithoutPrefix();
    }

    @Override
    public @Nullable String getAbsoluteUrl() {
        return this.request.getAbsoluteUrl();
    }

    @Override
    public @Nullable AbsoluteUrl getTypedAbsoluteUrl() {
        return this.request.getTypedAbsoluteUrl();
    }

    @Override
    public RequestMethod getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getHost() {
        return this.request.getHost();
    }

    @Override
    public int getPort() {
        return this.request.getPort();
    }

    @Override
    public String getClientIp() {
        return this.request.getClientIp();
    }

    @Override
    public String getHeader(String key) {
        return this.request.getHeader(key);
    }

    @Override
    public HttpHeader header(String key) {
        return this.request.header(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.request.contentTypeHeader();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.request.getHeaders();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.request.containsHeader(key);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        return this.request.getAllHeaderKeys();
    }

    @Override
    @JsonIgnore
    public PathParams getPathParameters() {
        return this.request.getPathParameters();
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return this.request.queryParameter(key);
    }

    @Override
    public FormParameter formParameter(String key) {
        return this.request.formParameter(key);
    }

    @Override
    public Map<String, FormParameter> formParameters() {
        return this.request.formParameters();
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return this.request.getCookies();
    }

    @Override
    public byte[] getBody() {
        return this.request.getBody();
    }

    @Override
    public String getBodyAsString() {
        return this.request.getBodyAsString();
    }

    @Override
    public String getBodyAsBase64() {
        return this.request.getBodyAsBase64();
    }

    @Override
    public boolean isMultipart() {
        return this.request.isMultipart();
    }

    @Override
    public Collection<Request.Part> getParts() {
        return this.request.getParts();
    }

    @Override
    public Request.Part getPart(String name) {
        return this.request.getPart(name);
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.request.isBrowserProxyRequest();
    }

    @Override
    public Optional<Request> getOriginalRequest() {
        return this.request.getOriginalRequest();
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }
}

