/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractFormattingHelper
extends HandlebarsHelper<Object> {
    abstract String getName();

    abstract String getDataFormat();

    public Object apply(Object context, Options options) throws IOException {
        Format format;
        String bodyText = options.tagType == TagType.SECTION ? options.fn().toString().trim() : (context instanceof CharSequence ? context.toString().trim() : "");
        if (bodyText.isEmpty()) {
            return this.handleError(String.format("%s should take a block of %s to format or a single parameter of type String", this.getName(), this.getDataFormat()));
        }
        Object formatOption = options.hash.get("format");
        if (formatOption == null) {
            format = Format.pretty;
        } else if (formatOption instanceof Format) {
            format = (Format)((Object)formatOption);
        } else if (formatOption instanceof CharSequence) {
            try {
                format = Format.valueOf(formatOption.toString());
            }
            catch (IllegalArgumentException e) {
                return this.handleError(String.format("%s: format [%s] should be one of %s", this.getName(), formatOption, Arrays.toString((Object[])Format.values())));
            }
        } else {
            return this.handleError(String.format("%s: format [%s] of type [%s should be a %s or a String and one of %s]", this.getName(), formatOption, formatOption.getClass().getName(), Format.class.getSimpleName(), Arrays.toString((Object[])Format.values())));
        }
        return this.apply(bodyText, format);
    }

    protected abstract String apply(String var1, Format var2);

    public static enum Format {
        pretty,
        compact;

    }
}

