/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.NotPermittedException;
import com.github.tomakehurst.wiremock.recording.NotRecordingException;
import java.util.Objects;

public class ClientError
extends RuntimeException {
    private final Errors errors;

    public ClientError(Errors errors) {
        super(Json.write(errors));
        this.errors = errors;
    }

    protected ClientError(Throwable cause, Errors errors) {
        super(Json.write(errors), cause);
        this.errors = errors;
    }

    public static ClientError fromErrors(Errors errors) {
        Integer errorCode = errors.first().getCode();
        if (errorCode == null) {
            return new ClientError(errors);
        }
        return switch (errorCode) {
            case 10 -> new InvalidInputException(errors);
            case 30 -> new NotRecordingException();
            case 50 -> new NotPermittedException(errors);
            default -> new ClientError(errors);
        };
    }

    public Errors getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientError that = (ClientError)o;
        return Objects.equals(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hashCode(this.errors);
    }
}

