/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.LogNormal;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.UniformDistribution;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Path;

public class ResponseDefinitionBuilder {
    protected final ResponseDefinition.Builder builder;

    public ResponseDefinitionBuilder() {
        this(new ResponseDefinition.Builder());
    }

    private ResponseDefinitionBuilder(ResponseDefinition.Builder builder) {
        this.builder = builder;
    }

    public static ResponseDefinitionBuilder like(ResponseDefinition responseDefinition) {
        return new ResponseDefinitionBuilder(responseDefinition.toBuilder());
    }

    public static ResponseDefinition jsonResponse(Object body) {
        return ResponseDefinitionBuilder.jsonResponse(body, 200);
    }

    public static ResponseDefinition jsonResponse(Object body, int status) {
        return new ResponseDefinitionBuilder().withBody(Json.write(body)).withStatus(status).withHeader("Content-Type", "application/json").build();
    }

    public ResponseDefinitionBuilder but() {
        return this;
    }

    public ResponseDefinitionBuilder withStatus(int status) {
        this.builder.setStatus(status);
        return this;
    }

    public ResponseDefinitionBuilder withHeader(String key, String ... values) {
        this.builder.headers(builder -> builder.add(key, values));
        return this;
    }

    public ResponseDefinitionBuilder withBodyFile(String fileName) {
        this.builder.setBodyFileName(fileName);
        return this;
    }

    public ResponseDefinitionBuilder withBody(String body) {
        this.builder.setBody(Body.fromOneOf(null, body, null, null));
        return this;
    }

    public ResponseDefinitionBuilder withBody(byte[] body) {
        this.builder.setBody(Body.fromOneOf(body, null, null, null));
        return this;
    }

    public ResponseDefinitionBuilder withResponseBody(Body body) {
        this.builder.setBody(body);
        return this;
    }

    public ResponseDefinitionBuilder withJsonBody(JsonNode jsonBody) {
        this.builder.setBody(Body.fromOneOf(null, null, jsonBody, null));
        return this;
    }

    public ResponseDefinitionBuilder withFixedDelay(Integer milliseconds) {
        this.builder.setFixedDelayMilliseconds(milliseconds);
        return this;
    }

    public ResponseDefinitionBuilder withRandomDelay(DelayDistribution distribution) {
        this.builder.setDelayDistribution(distribution);
        return this;
    }

    public ResponseDefinitionBuilder withLogNormalRandomDelay(double medianMilliseconds, double sigma) {
        return this.withLogNormalRandomDelay(medianMilliseconds, sigma, null);
    }

    public ResponseDefinitionBuilder withLogNormalRandomDelay(double medianMilliseconds, double sigma, Double maxValue) {
        return this.withRandomDelay(new LogNormal(medianMilliseconds, sigma, maxValue));
    }

    public ResponseDefinitionBuilder withUniformRandomDelay(int lowerMilliseconds, int upperMilliseconds) {
        return this.withRandomDelay(new UniformDistribution(lowerMilliseconds, upperMilliseconds));
    }

    public ResponseDefinitionBuilder withChunkedDribbleDelay(int numberOfChunks, int totalDuration) {
        this.builder.setChunkedDribbleDelay(new ChunkedDribbleDelay(numberOfChunks, totalDuration));
        return this;
    }

    public ResponseDefinitionBuilder withTransformers(String ... responseTransformerNames) {
        this.builder.setTransformers(Arrays.asList(responseTransformerNames));
        return this;
    }

    public ResponseDefinitionBuilder withTransformerParameters(Map<String, Object> parameters) {
        this.builder.setTransformerParameters(this.builder.getTransformerParameters().merge(Parameters.from(parameters)));
        return this;
    }

    public ResponseDefinitionBuilder withTransformerParameter(String name, Object value) {
        return this.withTransformerParameters(Map.of(name, value));
    }

    public ResponseDefinitionBuilder withTransformer(String transformerName, String parameterKey, Object parameterValue) {
        this.withTransformers(transformerName);
        this.withTransformerParameter(parameterKey, parameterValue);
        return this;
    }

    public ProxyResponseDefinitionBuilder proxiedFrom(String proxyBaseUrl) {
        this.builder.setProxyBaseUrl(proxyBaseUrl);
        return new ProxyResponseDefinitionBuilder(this);
    }

    public ResponseDefinitionBuilder withGzipDisabled(boolean gzipDisabled) {
        if (gzipDisabled) {
            this.withHeader("Content-Encoding", "none");
        }
        return this;
    }

    public static ResponseDefinitionBuilder responseDefinition() {
        return new ResponseDefinitionBuilder();
    }

    public static <T> ResponseDefinitionBuilder okForJson(T body) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody(Json.write(body)).withHeader("Content-Type", "application/json");
    }

    public static <T> ResponseDefinitionBuilder okForEmptyJson() {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody("{}").withHeader("Content-Type", "application/json");
    }

    public ResponseDefinitionBuilder withHeaders(HttpHeaders headers) {
        this.builder.setHeaders(headers);
        return this;
    }

    public ResponseDefinitionBuilder withBase64Body(String base64Body) {
        this.builder.setBody(Body.fromOneOf(null, null, null, base64Body));
        return this;
    }

    public ResponseDefinitionBuilder withStatusMessage(String message) {
        this.builder.setStatusMessage(message);
        return this;
    }

    public ResponseDefinitionBuilder withFault(Fault fault) {
        this.builder.setFault(fault);
        return this;
    }

    public ResponseDefinition build() {
        return this.build(new HttpHeaders(), List.of(), null);
    }

    protected ResponseDefinition build(HttpHeaders additionalProxyRequestHeaders, List<String> removeProxyRequestHeaders, @Nullable Path proxyUrlPrefixToRemove) {
        return this.builder.setAdditionalProxyRequestHeaders(additionalProxyRequestHeaders).setRemoveProxyRequestHeaders(removeProxyRequestHeaders).setProxyUrlPrefixToRemove(proxyUrlPrefixToRemove).build();
    }

    public static class ProxyResponseDefinitionBuilder
    extends ResponseDefinitionBuilder {
        public ProxyResponseDefinitionBuilder(ResponseDefinitionBuilder from) {
            super(from.builder);
        }

        public ProxyResponseDefinitionBuilder withAdditionalRequestHeader(String key, String value) {
            this.builder.setAdditionalProxyRequestHeaders(this.builder.getAdditionalProxyRequestHeaders().plus(new HttpHeader(key, value)));
            return this;
        }

        public ProxyResponseDefinitionBuilder withAdditionalRequestHeaders(HttpHeaders headers) {
            this.builder.setAdditionalProxyRequestHeaders(headers);
            return this;
        }

        public ProxyResponseDefinitionBuilder withRemoveRequestHeader(String key) {
            this.builder.getRemoveProxyRequestHeaders().add(key.toLowerCase());
            return this;
        }

        public ProxyResponseDefinitionBuilder withRemoveRequestHeaders(List<String> keys) {
            this.builder.setRemoveProxyRequestHeaders(keys);
            return this;
        }

        public ProxyResponseDefinitionBuilder withProxyUrlPrefixToRemove(String proxyUrlPrefixToRemove) {
            this.builder.setProxyUrlPrefixToRemove(proxyUrlPrefixToRemove);
            return this;
        }

        @Override
        public ResponseDefinition build() {
            return super.build(this.builder.getAdditionalProxyRequestHeaders(), this.builder.getRemoveProxyRequestHeaders(), this.builder.getProxyUrlPrefixToRemove());
        }
    }
}

