/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.message.MessagePattern;

public class WaitForMessageEventRequest {
    private final MessagePattern pattern;
    private final long timeoutMillis;
    private final Integer count;

    @JsonCreator
    public WaitForMessageEventRequest(@JsonProperty(value="pattern") MessagePattern pattern, @JsonProperty(value="timeoutMillis") long timeoutMillis, @JsonProperty(value="count") Integer count) {
        this.pattern = pattern != null ? pattern : MessagePattern.ANYTHING;
        this.timeoutMillis = timeoutMillis;
        this.count = count;
    }

    public static WaitForMessageEventRequest forSingleEvent(MessagePattern pattern, long timeoutMillis) {
        return new WaitForMessageEventRequest(pattern, timeoutMillis, null);
    }

    public static WaitForMessageEventRequest forMultipleEvents(MessagePattern pattern, long timeoutMillis, int count) {
        return new WaitForMessageEventRequest(pattern, timeoutMillis, count);
    }

    public MessagePattern getPattern() {
        return this.pattern;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public Integer getCount() {
        return this.count;
    }

    @JsonIgnore
    public boolean isMultipleEvents() {
        return this.count != null && this.count > 1;
    }
}

