/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidParameterException;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Query;
import org.wiremock.url.QueryParamKey;
import org.wiremock.url.QueryParamValue;

public class ServeEventQuery {
    public static final ServeEventQuery ALL = new ServeEventQuery(false, null);
    public static final ServeEventQuery ALL_UNMATCHED = new ServeEventQuery(true, null);
    private static final QueryParamKey UNMATCHED_KEY = QueryParamKey.encode((String)"unmatched");
    private static final QueryParamValue TRUE_PARAM_VALUE = QueryParamValue.encode((String)"true");
    private static final QueryParamKey MATCHING_STUB_KEY = QueryParamKey.encode((String)"matchingStub");
    private final boolean onlyUnmatched;
    private final UUID stubMappingId;

    public static ServeEventQuery forStubMapping(StubMapping stubMapping) {
        return new ServeEventQuery(false, stubMapping.getId());
    }

    public static ServeEventQuery forStubMapping(UUID stubMappingId) {
        return new ServeEventQuery(false, stubMappingId);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static ServeEventQuery fromRequest(Request request) {
        Query query = request.getPathAndQueryWithoutPrefix().getQueryOrEmpty();
        @Nullable List unmatchedParameter = query.get(UNMATCHED_KEY);
        boolean unmatched = unmatchedParameter.contains(TRUE_PARAM_VALUE);
        UUID stubMappingId = ServeEventQuery.toUuid(query, MATCHING_STUB_KEY);
        return new ServeEventQuery(unmatched, stubMappingId);
    }

    private static UUID toUuid(Query query, QueryParamKey key) {
        QueryParamValue parameter = query.getFirst(key);
        try {
            return parameter != null ? UUID.fromString(parameter.decode()) : null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParameterException(Errors.single(15, "Query parameter " + String.valueOf(key) + " value '" + String.valueOf(parameter) + "' is not a valid UUID"));
        }
    }

    public ServeEventQuery(@JsonProperty(value="onlyUnmatched") boolean onlyUnmatched, @JsonProperty(value="stubMappingId") UUID stubMappingId) {
        this.onlyUnmatched = onlyUnmatched;
        this.stubMappingId = stubMappingId;
    }

    public boolean isOnlyUnmatched() {
        return this.onlyUnmatched;
    }

    public UUID getStubMappingId() {
        return this.stubMappingId;
    }

    public List<ServeEvent> filter(List<ServeEvent> events) {
        if (!this.onlyUnmatched && this.stubMappingId == null) {
            return events;
        }
        Predicate<ServeEvent> matchPredicate = this.onlyUnmatched ? serveEvent -> !serveEvent.getWasMatched() : serveEvent -> true;
        Predicate<ServeEvent> stubPredicate = this.stubMappingId != null ? serveEvent -> serveEvent.getWasMatched() && serveEvent.getStubMapping().getId().equals(this.stubMappingId) : serveEvent -> true;
        return events.stream().filter(matchPredicate).filter(stubPredicate).collect(Collectors.toList());
    }
}

