/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.util.Objects;
import org.wiremock.url.Path;

public class RequestSpec {
    private final RequestMethod method;
    private final PathTemplate uriTemplate;

    public RequestSpec(RequestMethod method, String uriTemplate) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(uriTemplate);
        this.method = method;
        this.uriTemplate = new PathTemplate(uriTemplate);
    }

    public static RequestSpec requestSpec(RequestMethod method, String path) {
        return new RequestSpec(method, path);
    }

    public RequestMethod method() {
        return this.method;
    }

    public PathTemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public String path() {
        return this.path(PathParams.empty());
    }

    public String path(PathParams pathParams) {
        return this.uriTemplate.render(pathParams);
    }

    public boolean matches(RequestMethod method, Path path) {
        return (this.method.equals(RequestMethod.ANY) || this.method.equals(method)) && this.uriTemplate.matches(path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestSpec that = (RequestSpec)o;
        if (!this.method.equals(that.method)) {
            return false;
        }
        return this.uriTemplate.equals(that.uriTemplate);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.uriTemplate.hashCode();
        return result;
    }
}

