/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.verification.MessageJournalDisabledException;

public class MessageVerificationResult {
    private final int count;
    private final boolean messageJournalDisabled;

    @JsonCreator
    public MessageVerificationResult(@JsonProperty(value="count") int count, @JsonProperty(value="messageJournalDisabled") boolean messageJournalDisabled) {
        this.count = count;
        this.messageJournalDisabled = messageJournalDisabled;
    }

    public static MessageVerificationResult from(String json) {
        return Json.read(json, MessageVerificationResult.class);
    }

    public static MessageVerificationResult withCount(int count) {
        return new MessageVerificationResult(count, false);
    }

    public static MessageVerificationResult withMessageJournalDisabled() {
        return new MessageVerificationResult(-1, true);
    }

    public int getCount() {
        return this.count;
    }

    public boolean isMessageJournalDisabled() {
        return this.messageJournalDisabled;
    }

    public void assertMessageJournalEnabled() {
        if (this.messageJournalDisabled) {
            throw new MessageJournalDisabledException();
        }
    }
}

