/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store.files;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.KeyLocks;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.store.ObjectStore;
import com.github.tomakehurst.wiremock.store.files.PathBased;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class FileSourceJsonObjectStore
implements ObjectStore,
PathBased {
    private final FileSource fileSource;
    private final KeyLocks keyLocks = new KeyLocks();

    public FileSourceJsonObjectStore(String root) {
        this.fileSource = new SingleRootFileSource(root);
    }

    public FileSourceJsonObjectStore(FileSource fileSource) {
        this.fileSource = fileSource;
    }

    @Override
    public Stream<String> getAllKeys() {
        String rootPath = new File(this.fileSource.getUri().getSchemeSpecificPart()).getPath();
        return this.fileSource.listFilesRecursively().stream().map(TextFile::getPath).map(path -> path.substring(rootPath.length() + 1));
    }

    @Override
    public Optional<Object> get(String key) {
        return this.get(key, Object.class);
    }

    @Override
    public <T> Optional<T> get(String key, Class<T> type) {
        return this.getBytes(key).map(bytes -> Exceptions.uncheck(() -> Json.read(bytes, type), type));
    }

    @Override
    public <T> T compute(String key, Function<T, T> valueFunction) {
        return (T)this.keyLocks.withLock(key, () -> {
            Object newValue = this.get(key).map(value -> valueFunction.apply(value)).orElseGet(() -> valueFunction.apply(null));
            this.put(key, newValue);
            return newValue;
        });
    }

    private Optional<byte[]> getBytes(String key) {
        try {
            return Optional.of(this.fileSource.getBinaryFileNamed(FileSourceJsonObjectStore.createFileName(key)).readContents());
        }
        catch (Exception exception) {
            if (!(exception instanceof FileNotFoundException)) {
                LocalNotifier.notifier().error("Error when working with FileSource:\n" + Json.write(exception.getMessage()));
                return Optional.of(Exceptions.throwUnchecked(exception, byte[].class));
            }
            return Optional.empty();
        }
    }

    @Override
    public void put(String key, Object content) {
        String json = Json.write(content);
        String fileName = FileSourceJsonObjectStore.createFileName(key);
        this.fileSource.writeBinaryFile(fileName, Strings.bytesFromString(json));
    }

    @Override
    public void remove(String key) {
        this.fileSource.deleteFile(FileSourceJsonObjectStore.createFileName(key));
    }

    @Override
    public void clear() {
        this.fileSource.listFilesRecursively().forEach(file -> this.fileSource.deleteFile(file.getPath()));
    }

    public FileSource getFileSource() {
        return this.fileSource;
    }

    @Override
    public String getPath() {
        return this.fileSource.getPath();
    }

    private static String createFileName(String key) {
        return key + ".json";
    }
}

