/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.proxy;

import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.extension.ResponseTransformerV2;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.Host;
import org.wiremock.url.HostAndPort;
import org.wiremock.url.Path;
import org.wiremock.url.Port;
import org.wiremock.url.Scheme;
import org.wiremock.url.SchemeRegistry;
import org.wiremock.url.Uri;
import org.wiremock.url.Url;

public class ProxiedHostnameRewriteResponseTransformer
implements ResponseTransformerV2 {
    private static final String possibleSchemePrefixes = "[^a-zA-Z0-9+-.]";
    private static final String possibleHostPrefix = "[^a-zA-Z0-9-.!$&'()*+,;=:/]";
    private static final String possibleHostPostfix = "[^a-zA-Z0-9-.!$&'()*+,;=:]";
    private static final String possiblePortPostfix = "\\D";

    @Override
    public Response transform(Response response, ServeEvent serveEvent) {
        if (!serveEvent.getResponseDefinition().isProxyResponse()) {
            return response;
        }
        SubstitutionData substitutionData = ProxiedHostnameRewriteResponseTransformer.getSubstitutionData(serveEvent);
        List<HttpHeader> updatedHeaderList = response.getHeaders().all().stream().map(header -> new HttpHeader(header.key(), (Collection<String>)header.values().stream().map(value -> ProxiedHostnameRewriteResponseTransformer.applySubstitutions(value, substitutionData)).toList())).toList();
        HttpHeaders updatedHeaders = new HttpHeaders(updatedHeaderList);
        Response.Builder responseBuilder = Response.Builder.like(response).headers(updatedHeaders);
        byte[] initialBody = response.getBody();
        if (initialBody != null && initialBody.length > 0 && ContentTypes.determineIsTextFromMimeType(ProxiedHostnameRewriteResponseTransformer.getMimeType(response))) {
            byte[] updatedBody;
            if (Gzip.isGzipped(initialBody)) {
                String uncompressedBody = Gzip.unGzipToString(initialBody);
                uncompressedBody = ProxiedHostnameRewriteResponseTransformer.applySubstitutions(uncompressedBody, substitutionData);
                updatedBody = Gzip.gzip(uncompressedBody.getBytes());
            } else {
                String responseBodyAsString = response.getBodyAsString();
                responseBodyAsString = ProxiedHostnameRewriteResponseTransformer.applySubstitutions(responseBodyAsString, substitutionData);
                updatedBody = responseBodyAsString.getBytes();
            }
            responseBuilder.body(updatedBody);
            if (updatedHeaders.getHeader("Content-Length").isPresent()) {
                responseBuilder.headers(ProxiedHostnameRewriteResponseTransformer.setContentLengthHeader(updatedHeaders, String.valueOf(updatedBody.length)));
            }
        }
        return responseBuilder.build();
    }

    private static String applySubstitutions(String input, SubstitutionData data) {
        return data.combinedPattern.matcher(input).replaceAll(data::getReplacement);
    }

    @Override
    public String getName() {
        return "proxied-hostname-rewrite";
    }

    @Override
    public boolean applyGlobally() {
        return false;
    }

    private static HttpHeaders setContentLengthHeader(HttpHeaders headers, String value) {
        List<HttpHeader> filteredHeaders = headers.all().stream().filter(h -> !h.keyEquals("Content-Length")).collect(Collectors.toList());
        filteredHeaders.add(new HttpHeader("Content-Length", value));
        return new HttpHeaders(filteredHeaders);
    }

    private static String getMimeType(Response response) {
        HttpHeaders responseHeaders = response.getHeaders();
        return responseHeaders != null && responseHeaders.getContentTypeHeader() != null ? responseHeaders.getContentTypeHeader().mimeTypePart() : null;
    }

    private static SubstitutionData getSubstitutionData(ServeEvent serveEvent) {
        AbsoluteUrl proxyUrl = serveEvent.getRequest().getTypedAbsoluteUrl().transform(b -> ((Uri.Transformer)b.setPath(Path.EMPTY)).setQuery(null));
        Port proxyDefaultPort = proxyUrl.getScheme().getDefaultPort();
        Port proxyActualPort = proxyUrl.getResolvedPort();
        Scheme proxyWsScheme = ProxiedHostnameRewriteResponseTransformer.getWebSocketScheme(proxyUrl);
        AbsoluteUrl originUrl = AbsoluteUrl.parse((String)serveEvent.getResponseDefinition().getProxyBaseUrl()).transform(b -> ((Uri.Transformer)b.setPath(Path.EMPTY)).setQuery(null));
        Port originDefaultPort = originUrl.getScheme().getDefaultPort();
        Port originActualPort = originUrl.getResolvedPort();
        Scheme originWsScheme = ProxiedHostnameRewriteResponseTransformer.getWebSocketScheme(originUrl);
        LinkedHashMap<Pattern, String> replacements = new LinkedHashMap<Pattern, String>();
        if (Objects.equals(originActualPort, originDefaultPort)) {
            if (Objects.equals(proxyActualPort, proxyDefaultPort)) {
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost(), originActualPort), proxyUrl.transform(it -> it.setPort(proxyActualPort)).toString());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost()), proxyUrl.transform(it -> it.setPort(null)).toString());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost(), originActualPort), ((Url.Builder)((Url.Builder)((Url.Builder)Url.builder().setScheme(proxyWsScheme).setHost(proxyUrl.getHost())).setPort(proxyActualPort)).setPath(Path.EMPTY)).build().toString());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost()), ((Url.Builder)((Url.Builder)Url.builder().setScheme(proxyWsScheme).setHost(proxyUrl.getHost())).setPath(Path.EMPTY)).build().toString());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost(), originActualPort), HostAndPort.of((Host)proxyUrl.getHost(), (Port)proxyActualPort).toString());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost()), proxyUrl.getHost().toString());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.pattern("[^:]", "//" + String.valueOf(originUrl.getHost()), possibleHostPrefix), "//" + String.valueOf(proxyUrl.getHost()));
            } else {
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost(), originActualPort), String.valueOf(proxyUrl.getScheme()) + "://" + String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost()), String.valueOf(proxyUrl.getScheme()) + "://" + String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost(), originActualPort), String.valueOf(proxyWsScheme) + "://" + String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost()), String.valueOf(proxyWsScheme) + "://" + String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
                replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost(), originActualPort), String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
                replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost()), String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
                replacements.put(ProxiedHostnameRewriteResponseTransformer.pattern("[^:]", "//" + String.valueOf(originUrl.getHost()), possibleHostPrefix), String.valueOf(proxyUrl.getScheme()) + "://" + String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
            }
        } else if (Objects.equals(proxyActualPort, proxyDefaultPort)) {
            replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost(), originActualPort), String.valueOf(proxyUrl.getScheme()) + "://" + String.valueOf(proxyUrl.getHost()));
            replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost(), originActualPort), String.valueOf(proxyWsScheme) + "://" + String.valueOf(proxyUrl.getHost()));
            replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost(), originActualPort), proxyUrl.getHost().toString());
            replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost()), proxyUrl.getHost().toString());
        } else {
            replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost(), originActualPort), String.valueOf(proxyUrl.getScheme()) + "://" + String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
            replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost(), originActualPort), String.valueOf(proxyWsScheme) + "://" + String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
            replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost(), originActualPort), String.valueOf(proxyUrl.getHost()) + ":" + String.valueOf(proxyActualPort));
            replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost()), proxyUrl.getHost().toString());
        }
        return new SubstitutionData(replacements);
    }

    private static Pattern fullUrlPattern(Scheme scheme, Host host) {
        return ProxiedHostnameRewriteResponseTransformer.pattern(possibleSchemePrefixes, String.valueOf(scheme) + "://" + String.valueOf(host), possibleHostPostfix);
    }

    private static Pattern fullUrlPattern(Scheme scheme, Host host, Port port) {
        return ProxiedHostnameRewriteResponseTransformer.pattern(possibleSchemePrefixes, String.valueOf(scheme) + "://" + String.valueOf(host) + ":" + String.valueOf(port), possiblePortPostfix);
    }

    private static Pattern schemelessPattern(Host host) {
        return ProxiedHostnameRewriteResponseTransformer.pattern(possibleHostPrefix, host.toString(), possibleHostPostfix);
    }

    private static Pattern schemelessPattern(Host host, Port port) {
        return ProxiedHostnameRewriteResponseTransformer.pattern(possibleHostPrefix, String.valueOf(host) + ":" + String.valueOf(port), possiblePortPostfix);
    }

    private static Pattern pattern(String prefixPattern, String literal, String postfixPattern) {
        return Pattern.compile("(?<=" + prefixPattern + "|^)" + Pattern.quote(literal) + "(?=" + postfixPattern + "|$)", 2);
    }

    private static Scheme getWebSocketScheme(AbsoluteUrl proxyUrl) {
        return proxyUrl.getScheme().equals(SchemeRegistry.https) ? SchemeRegistry.wss : SchemeRegistry.ws;
    }

    private static class SubstitutionData {
        private final Pattern combinedPattern;
        private final Map<String, String> replacementMap = new LinkedHashMap<String, String>();

        SubstitutionData(Map<Pattern, String> substitutions) {
            StringBuilder combinedPatternBuilder = new StringBuilder();
            int groupIndex = 0;
            for (Map.Entry<Pattern, String> entry : substitutions.entrySet()) {
                if (groupIndex > 0) {
                    combinedPatternBuilder.append("|");
                }
                String patternStr = entry.getKey().pattern();
                combinedPatternBuilder.append("(").append(patternStr).append(")");
                this.replacementMap.put(String.valueOf(groupIndex), entry.getValue());
                ++groupIndex;
            }
            this.combinedPattern = Pattern.compile(combinedPatternBuilder.toString(), 2);
        }

        String getReplacement(MatchResult matchResult) {
            for (int i = 1; i <= matchResult.groupCount(); ++i) {
                if (matchResult.group(i) == null) continue;
                return this.replacementMap.get(String.valueOf(i - 1));
            }
            return matchResult.group(0);
        }
    }
}

