/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.message.ChannelPattern;
import com.github.tomakehurst.wiremock.message.ChannelType;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import java.util.Collections;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RequestInitiatedChannelPattern
implements ChannelPattern {
    private final RequestPattern initiatingRequestPattern;
    private final ChannelType channelType;

    @JsonCreator
    public RequestInitiatedChannelPattern(@JsonProperty(value="type") ChannelType type, @JsonProperty(value="initiatingRequestPattern") RequestPattern initiatingRequestPattern) {
        this.channelType = type;
        this.initiatingRequestPattern = initiatingRequestPattern;
    }

    public static RequestInitiatedChannelPattern forRequestPattern(ChannelType channelType, RequestPattern requestPattern) {
        return new RequestInitiatedChannelPattern(channelType, requestPattern);
    }

    @Override
    @JsonInclude
    public ChannelType getType() {
        return this.channelType;
    }

    public RequestPattern getInitiatingRequestPattern() {
        return this.initiatingRequestPattern;
    }

    @Override
    public boolean matches(MessageChannel channel) {
        if (channel instanceof RequestInitiatedMessageChannel) {
            return this.matches(((RequestInitiatedMessageChannel)channel).getInitiatingRequest());
        }
        return this.initiatingRequestPattern == null;
    }

    public boolean matches(Request channelRequest) {
        if (this.initiatingRequestPattern != null) {
            MatchResult channelMatch = this.initiatingRequestPattern.match(channelRequest, Collections.emptyMap());
            return channelMatch.isExactMatch();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestInitiatedChannelPattern that = (RequestInitiatedChannelPattern)o;
        return Objects.equals(this.initiatingRequestPattern, that.initiatingRequestPattern);
    }

    public int hashCode() {
        return Objects.hash(this.initiatingRequestPattern);
    }
}

