/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.github.tomakehurst.wiremock.common.InputStreamSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.entity.BinaryEntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.CompressionType;
import com.github.tomakehurst.wiremock.common.entity.EncodingType;
import com.github.tomakehurst.wiremock.common.entity.Entity;
import com.github.tomakehurst.wiremock.common.entity.EntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.FormatType;
import com.github.tomakehurst.wiremock.common.entity.StringEntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.TextEntityDefinition;
import com.github.tomakehurst.wiremock.extension.MessageActionTransformer;
import com.github.tomakehurst.wiremock.message.ChannelTarget;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageAction;
import com.github.tomakehurst.wiremock.message.MessageActionContext;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessageChannels;
import com.github.tomakehurst.wiremock.message.MessageDefinition;
import com.github.tomakehurst.wiremock.message.MessageStubMapping;
import com.github.tomakehurst.wiremock.message.MessageStubMappings;
import com.github.tomakehurst.wiremock.message.OriginatingChannelTarget;
import com.github.tomakehurst.wiremock.message.RequestInitiatedChannelTarget;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.message.SendMessageAction;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.verification.MessageJournal;
import com.github.tomakehurst.wiremock.verification.MessageServeEvent;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class MessageStubRequestHandler {
    private final MessageStubMappings messageStubMappings;
    private final MessageChannels messageChannels;
    private final MessageJournal messageJournal;
    private final Stores stores;
    private final List<MessageActionTransformer> actionTransformers;

    public MessageStubRequestHandler(MessageStubMappings messageStubMappings, MessageChannels messageChannels, MessageJournal messageJournal, Stores stores, List<MessageActionTransformer> actionTransformers) {
        this.messageStubMappings = messageStubMappings;
        this.messageChannels = messageChannels;
        this.messageJournal = messageJournal;
        this.stores = stores;
        this.actionTransformers = actionTransformers != null ? actionTransformers : Collections.emptyList();
    }

    public void processMessage(MessageChannel channel, Message message) {
        Optional<MessageStubMapping> matchingStub = this.messageStubMappings.findMatchingStub(channel, message);
        if (matchingStub.isPresent()) {
            MessageStubMapping stub = matchingStub.get();
            this.executeActions(stub, channel, message);
            MessageServeEvent event = MessageServeEvent.receivedMatched(channel, message, stub);
            this.messageJournal.messageReceived(event);
        } else {
            MessageServeEvent event = MessageServeEvent.receivedUnmatched(channel, message);
            this.messageJournal.messageReceived(event);
        }
    }

    private void executeActions(MessageStubMapping stub, MessageChannel originatingChannel, Message incomingMessage) {
        MessageActionContext context = MessageActionContext.forIncomingMessage(stub, originatingChannel, incomingMessage);
        for (MessageAction action : stub.getActions()) {
            MessageAction transformedAction = this.applyTransformations(action, context);
            this.executeAction(transformedAction, originatingChannel, incomingMessage);
        }
    }

    private MessageAction applyTransformations(MessageAction action, MessageActionContext context) {
        MessageAction result = action;
        for (MessageActionTransformer transformer : this.actionTransformers) {
            if (!transformer.applyGlobally() && !action.hasTransformer(transformer)) continue;
            result = transformer.transform(result, context);
        }
        return result;
    }

    private void executeAction(MessageAction action, MessageChannel originatingChannel, Message incomingMessage) {
        if (action instanceof SendMessageAction) {
            SendMessageAction sendAction = (SendMessageAction)action;
            this.executeSendMessageAction(sendAction, originatingChannel);
        }
    }

    private void executeSendMessageAction(SendMessageAction action, MessageChannel originatingChannel) {
        Message message = this.resolveToMessage(action.getMessage());
        ChannelTarget target = action.getChannelTarget();
        if (target instanceof OriginatingChannelTarget) {
            originatingChannel.sendMessage(message);
        } else if (target instanceof RequestInitiatedChannelTarget) {
            RequestInitiatedChannelTarget requestTarget = (RequestInitiatedChannelTarget)target;
            List<RequestInitiatedMessageChannel> matchingChannels = requestTarget.getChannelType() != null ? this.messageChannels.findByTypeAndRequestPattern(requestTarget.getChannelType(), requestTarget.getRequestPattern(), Collections.emptyMap()) : this.messageChannels.findByRequestPattern(requestTarget.getRequestPattern(), Collections.emptyMap());
            for (RequestInitiatedMessageChannel channel : matchingChannels) {
                channel.sendMessage(message);
            }
        }
    }

    public Message resolveToMessage(MessageDefinition messageDefinition) {
        return MessageStubRequestHandler.resolveToMessage(messageDefinition, this.stores);
    }

    public static Message resolveToMessage(MessageDefinition messageDefinition, Stores stores) {
        Entity entity = MessageStubRequestHandler.resolveEntity(messageDefinition.getBody(), stores);
        return new Message(entity);
    }

    private static Entity resolveEntity(EntityDefinition definition, Stores stores) {
        if (definition instanceof StringEntityDefinition) {
            String value = ((StringEntityDefinition)definition).getValue();
            byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : new byte[]{};
            InputStreamSource streamSource = () -> new ByteArrayInputStream(bytes);
            return new Entity(EncodingType.TEXT, FormatType.TEXT, CompressionType.NONE, streamSource);
        }
        if (definition instanceof BinaryEntityDefinition) {
            BinaryEntityDefinition binaryDef = (BinaryEntityDefinition)definition;
            byte[] bytes = MessageStubRequestHandler.resolveBinaryEntityData(binaryDef, stores);
            InputStreamSource streamSource = () -> new ByteArrayInputStream(bytes);
            return new Entity(EncodingType.BINARY, FormatType.BASE64, binaryDef.getCompression(), streamSource);
        }
        if (definition instanceof TextEntityDefinition) {
            TextEntityDefinition textDef = (TextEntityDefinition)definition;
            String resolvedData = MessageStubRequestHandler.resolveTextEntityData(textDef, stores);
            byte[] bytes = resolvedData != null ? resolvedData.getBytes(StandardCharsets.UTF_8) : new byte[]{};
            InputStreamSource streamSource = () -> new ByteArrayInputStream(bytes);
            return new Entity(EncodingType.TEXT, textDef.getFormat(), textDef.getCompression(), streamSource);
        }
        throw new UnsupportedOperationException("Resolution of " + definition.getClass().getSimpleName() + " is not yet supported");
    }

    private static String resolveTextEntityData(TextEntityDefinition definition, Stores stores) {
        Object data = definition.getData();
        if (data instanceof String) {
            String s = (String)data;
            return s;
        }
        if (data != null) {
            return Json.write(data);
        }
        String filePath = definition.getFilePath();
        if (filePath != null && stores != null) {
            BlobStore filesBlobStore = stores.getFilesBlobStore();
            return filesBlobStore.get(filePath).map(Strings::stringFromBytes).orElse(null);
        }
        String dataStore = definition.getDataStore();
        String dataRef = definition.getDataRef();
        if (dataStore != null && dataRef != null && stores != null) {
            return stores.getObjectStore(dataStore).get(dataRef).map(value -> {
                if (value instanceof String) {
                    String s = (String)value;
                    return s;
                }
                return Json.write(value);
            }).orElse(null);
        }
        return null;
    }

    private static byte[] resolveBinaryEntityData(BinaryEntityDefinition definition, Stores stores) {
        byte[] data = definition.getDataAsBytes();
        if (data != null) {
            return data;
        }
        String filePath = definition.getFilePath();
        if (filePath != null && stores != null) {
            BlobStore filesBlobStore = stores.getFilesBlobStore();
            return filesBlobStore.get(filePath).orElse(new byte[0]);
        }
        String dataStore = definition.getDataStore();
        String dataRef = definition.getDataRef();
        if (dataStore != null && dataRef != null && stores != null) {
            return stores.getObjectStore(dataStore).get(dataRef).map(value -> {
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    return bytes;
                }
                if (value instanceof String) {
                    String s = (String)value;
                    return Base64.getDecoder().decode(s);
                }
                return new byte[0];
            }).orElse(new byte[0]);
        }
        return new byte[0];
    }

    public MessageStubMappings getMessageStubMappings() {
        return this.messageStubMappings;
    }

    public MessageChannels getMessageChannels() {
        return this.messageChannels;
    }
}

