/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.verification.MessageServeEvent;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class MessagePattern {
    public static final MessagePattern ANYTHING = new MessagePattern(null, null);
    private final RequestPattern channelPattern;
    private final ContentPattern<?> bodyPattern;

    @JsonCreator
    public MessagePattern(@JsonProperty(value="channel") RequestPattern channelPattern, @JsonProperty(value="body") ContentPattern<?> bodyPattern) {
        this.channelPattern = channelPattern;
        this.bodyPattern = bodyPattern;
    }

    public static Builder messagePattern() {
        return new Builder();
    }

    public static MessagePattern create(Consumer<Builder> transformer) {
        Builder builder = MessagePattern.messagePattern();
        transformer.accept(builder);
        return builder.build();
    }

    public MessagePattern transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @JsonIgnore
    public RequestPattern getChannel() {
        return this.channelPattern;
    }

    @JsonProperty(value="body")
    public ContentPattern<?> getBodyPattern() {
        return this.bodyPattern;
    }

    public boolean matches(MessageChannel channel, Message message) {
        if (channel instanceof RequestInitiatedMessageChannel) {
            return this.matches(((RequestInitiatedMessageChannel)channel).getInitiatingRequest(), message);
        }
        return this.matches((Request)null, message);
    }

    public boolean matches(Request channelRequest, Message message) {
        MatchResult channelMatch;
        if (this.channelPattern != null && !(channelMatch = this.channelPattern.match(channelRequest, Collections.emptyMap())).isExactMatch()) {
            return false;
        }
        if (this.bodyPattern != null) {
            MatchResult messageMatch;
            if (this.bodyPattern instanceof StringValuePattern) {
                String messageBody = message != null ? message.getBodyAsString() : null;
                messageMatch = ((StringValuePattern)this.bodyPattern).match(messageBody);
            } else {
                byte[] messageBody = message != null ? message.getBodyAsBytes() : null;
                messageMatch = this.bodyPattern.match(messageBody);
            }
            if (!messageMatch.isExactMatch()) {
                return false;
            }
        }
        return true;
    }

    public boolean matches(MessageServeEvent event) {
        return this.matches(event.getChannelRequest(), event.getMessage());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagePattern that = (MessagePattern)o;
        return Objects.equals(this.channelPattern, that.channelPattern) && Objects.equals(this.bodyPattern, that.bodyPattern);
    }

    public int hashCode() {
        return Objects.hash(this.channelPattern, this.bodyPattern);
    }

    public String toString() {
        return Json.write(this);
    }

    public static class Builder {
        private RequestPattern channelPattern;
        private ContentPattern<?> bodyPattern;

        public Builder() {
        }

        public Builder(MessagePattern existing) {
            this.channelPattern = existing.channelPattern;
            this.bodyPattern = existing.bodyPattern;
        }

        public RequestPattern getChannelPattern() {
            return this.channelPattern;
        }

        public Builder setChannelPattern(RequestPattern channelPattern) {
            this.channelPattern = channelPattern;
            return this;
        }

        public Builder withChannelPattern(RequestPattern channelPattern) {
            return this.setChannelPattern(channelPattern);
        }

        public ContentPattern<?> getBodyPattern() {
            return this.bodyPattern;
        }

        public Builder setBodyPattern(ContentPattern<?> bodyPattern) {
            this.bodyPattern = bodyPattern;
            return this;
        }

        public Builder withBody(ContentPattern<?> bodyPattern) {
            return this.setBodyPattern(bodyPattern);
        }

        public MessagePattern build() {
            return new MessagePattern(this.channelPattern, this.bodyPattern);
        }
    }
}

