/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;

public class ChannelType {
    private final String name;
    private final Lifecycle lifecycle;
    private final Directionality directionality;
    public static ChannelType WEBSOCKET = new ChannelType("websocket", Lifecycle.REQUEST_INITIATED, Directionality.BIDIRECTIONAL);

    public ChannelType(String name, Lifecycle lifecycle, Directionality directionality) {
        this.name = name;
        this.lifecycle = lifecycle;
        this.directionality = directionality;
    }

    public boolean isRequestInitiated() {
        return this.getLifecycle() == Lifecycle.REQUEST_INITIATED;
    }

    public String getName() {
        return this.name;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public Directionality getDirectionality() {
        return this.directionality;
    }

    @JsonCreator
    public static ChannelType fromJson(String value) {
        return WEBSOCKET;
    }

    @JsonValue
    public String toJson() {
        return this.getName().toLowerCase(Locale.ROOT);
    }

    public static enum Lifecycle {
        REQUEST_INITIATED;

    }

    public static enum Directionality {
        BIDIRECTIONAL;

    }
}

