/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Map;
import java.util.Set;

public abstract class MultiRequestMethodPattern
extends RequestMethod {
    protected final Set<RequestMethod> methods;

    protected MultiRequestMethodPattern(String name, Set<RequestMethod> methods) {
        super(name);
        this.methods = methods;
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    @Override
    public String getExpected() {
        return this.getName() + ": " + this.methods.toString();
    }

    public static class IsNoneOf
    extends MultiRequestMethodPattern {
        public static final String NAME = "noneOf";

        public IsNoneOf(Set<RequestMethod> methods) {
            super(NAME, methods);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public Object value() {
            return Map.of(NAME, this.methods);
        }

        @Override
        public MatchResult match(RequestMethod value) {
            return this.methods.contains(value) ? MatchResult.noMatch(new SubEvent[0]) : MatchResult.exactMatch(new SubEvent[0]);
        }
    }

    public static class IsOneOf
    extends MultiRequestMethodPattern {
        public static final String NAME = "oneOf";

        public IsOneOf(Set<RequestMethod> methods) {
            super(NAME, methods);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public Object value() {
            return Map.of(NAME, this.methods);
        }

        @Override
        public MatchResult match(RequestMethod value) {
            return this.methods.contains(value) ? MatchResult.exactMatch(new SubEvent[0]) : MatchResult.noMatch(new SubEvent[0]);
        }
    }
}

