/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeadersJsonDeserializer;
import com.github.tomakehurst.wiremock.http.HttpHeadersJsonSerializer;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@JsonSerialize(using=HttpHeadersJsonSerializer.class)
@JsonDeserialize(using=HttpHeadersJsonDeserializer.class)
public class HttpHeaders {
    private final Multimap<CaseInsensitiveKey, String> headers;

    public HttpHeaders() {
        this.headers = ImmutableMultimap.of();
    }

    public HttpHeaders(HttpHeader ... headers) {
        this(Arrays.asList(headers));
    }

    public HttpHeaders(Iterable<HttpHeader> headers) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (HttpHeader header : (Iterable)ParameterUtils.getFirstNonNull(headers, Collections.emptyList())) {
            builder.putAll((Object)this.caseInsensitive(header.key()), header.values());
        }
        this.headers = builder.build();
    }

    public HttpHeaders(HttpHeaders headers) {
        this(headers.all());
    }

    private HttpHeaders(Multimap<CaseInsensitiveKey, String> headers) {
        this.headers = ImmutableMultimap.copyOf(headers);
    }

    public static HttpHeaders noHeaders() {
        return new HttpHeaders();
    }

    public HttpHeader getHeader(String key) {
        if (!this.headers.containsKey((Object)this.caseInsensitive(key))) {
            return HttpHeader.absent(key);
        }
        Collection values = this.headers.get((Object)this.caseInsensitive(key));
        return new HttpHeader(key, (Collection<String>)values);
    }

    public ContentTypeHeader getContentTypeHeader() {
        HttpHeader header = this.getHeader("Content-Type");
        if (header.isPresent()) {
            return new ContentTypeHeader(header.firstValue());
        }
        return ContentTypeHeader.absent();
    }

    public Collection<HttpHeader> all() {
        ArrayList<HttpHeader> httpHeaderList = new ArrayList<HttpHeader>();
        for (CaseInsensitiveKey key : this.headers.keySet()) {
            httpHeaderList.add(new HttpHeader(key.value(), (Collection<String>)this.headers.get((Object)key)));
        }
        return httpHeaderList;
    }

    public Set<String> keys() {
        return this.headers.keySet().stream().map(CaseInsensitiveKey::toString).collect(Collectors.toSet());
    }

    public static HttpHeaders copyOf(HttpHeaders source) {
        return new HttpHeaders(source);
    }

    public HttpHeaders transform(Consumer<Builder> transformer) {
        Builder builder = new Builder(this);
        transformer.accept(builder);
        return builder.build();
    }

    public int size() {
        return this.headers.asMap().size();
    }

    public HttpHeaders plus(HttpHeader ... additionalHeaders) {
        ArrayList<HttpHeader> httpHeaders = new ArrayList<HttpHeader>(this.all());
        httpHeaders.addAll(Arrays.asList(additionalHeaders));
        return new HttpHeaders(httpHeaders);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders)o;
        return this.headers != null ? this.headers.equals(that.headers) : that.headers == null;
    }

    public int hashCode() {
        return this.headers != null ? this.headers.hashCode() : 0;
    }

    public String toString() {
        if (this.headers.isEmpty()) {
            return "(no headers)\n";
        }
        StringBuilder outString = new StringBuilder();
        for (CaseInsensitiveKey key : this.headers.keySet()) {
            outString.append(key.toString()).append(": ").append(this.headers.get((Object)key)).append("\n");
        }
        return outString.toString();
    }

    private CaseInsensitiveKey caseInsensitive(String key) {
        return new CaseInsensitiveKey(key);
    }

    public static class Builder {
        private final ListMultimap<CaseInsensitiveKey, String> headers = MultimapBuilder.linkedHashKeys().arrayListValues().build();

        public Builder() {
        }

        public Builder(HttpHeaders httpHeaders) {
            this.headers.putAll(httpHeaders.headers);
        }

        public Builder setAll(HttpHeader ... headers) {
            return this.setAll(List.of(headers));
        }

        public Builder setAll(Iterable<HttpHeader> headers) {
            this.removeAll();
            for (HttpHeader header : headers) {
                this.add(header.caseInsensitiveKey(), header.values());
            }
            return this;
        }

        public Builder addAll(HttpHeader ... headers) {
            return this.addAll(List.of(headers));
        }

        public Builder addAll(Iterable<HttpHeader> headers) {
            for (HttpHeader header : headers) {
                this.add(header.caseInsensitiveKey(), header.values());
            }
            return this;
        }

        public Builder set(String key, String ... values) {
            return this.set(new CaseInsensitiveKey(key), values);
        }

        public Builder set(CaseInsensitiveKey key, String ... values) {
            this.set(key, List.of(values));
            return this;
        }

        public Builder set(String key, Iterable<String> values) {
            return this.set(new CaseInsensitiveKey(key), values);
        }

        public Builder set(CaseInsensitiveKey key, Iterable<String> values) {
            this.headers.replaceValues((Object)key, values);
            return this;
        }

        public Builder add(String key, String ... values) {
            this.add(new CaseInsensitiveKey(key), values);
            return this;
        }

        public Builder add(CaseInsensitiveKey key, String ... values) {
            this.add(key, List.of(values));
            return this;
        }

        public Builder add(String key, Iterable<String> values) {
            this.add(new CaseInsensitiveKey(key), values);
            return this;
        }

        public Builder add(CaseInsensitiveKey key, Iterable<String> values) {
            this.headers.putAll((Object)key, values);
            return this;
        }

        public Builder remove(String key) {
            return this.remove(new CaseInsensitiveKey(key));
        }

        public Builder remove(CaseInsensitiveKey key) {
            this.headers.removeAll((Object)key);
            return this;
        }

        public Builder removeAll() {
            this.headers.clear();
            return this;
        }

        public List<String> get(String key) {
            return this.get(new CaseInsensitiveKey(key));
        }

        public List<String> get(CaseInsensitiveKey key) {
            return this.headers.get((Object)key);
        }

        public Set<CaseInsensitiveKey> keys() {
            return this.headers.keySet();
        }

        public HttpHeaders build() {
            return new HttpHeaders((Multimap<CaseInsensitiveKey, String>)this.headers);
        }
    }
}

