/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.entity;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.InputStreamSource;
import com.github.tomakehurst.wiremock.common.Limit;
import com.github.tomakehurst.wiremock.common.entity.CompressionType;
import com.github.tomakehurst.wiremock.common.entity.EncodingType;
import com.github.tomakehurst.wiremock.common.entity.FormatType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.StringJoiner;

public class Entity {
    private final EncodingType encoding;
    private final FormatType format;
    private final CompressionType compression;
    private final InputStreamSource streamSource;

    public Entity(EncodingType encoding, FormatType format, CompressionType compression, InputStreamSource streamSource) {
        this.encoding = encoding;
        this.format = format;
        this.compression = compression;
        this.streamSource = streamSource;
    }

    public EncodingType getEncoding() {
        return this.encoding;
    }

    public FormatType getFormat() {
        return this.format;
    }

    public CompressionType getCompression() {
        return this.compression;
    }

    public byte[] getData() {
        return this.getData(Limit.UNLIMITED);
    }

    public byte[] getData(Limit sizeLimit) {
        return Exceptions.uncheck(() -> Entity.getBytesFromStream(this.streamSource, sizeLimit), byte[].class);
    }

    private static byte[] getBytesFromStream(InputStreamSource streamSource, Limit limit) throws IOException {
        try (InputStream stream = streamSource == null ? null : streamSource.getStream();){
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = limit != null && !limit.isUnlimited() ? stream.readNBytes(limit.getValue()) : stream.readAllBytes();
            return byArray;
        }
    }

    public InputStreamSource getStreamSource() {
        return this.streamSource;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return Objects.equals(this.encoding, entity.encoding) && Objects.equals(this.format, entity.format) && Objects.equals(this.compression, entity.compression);
    }

    public int hashCode() {
        return Objects.hash(this.encoding, this.format, this.compression);
    }

    public String toString() {
        return new StringJoiner(", ", Entity.class.getSimpleName() + "[", "]").add("encoding=" + String.valueOf(this.encoding)).add("format=" + String.valueOf(this.format)).add("compression=" + String.valueOf(this.compression)).add("streamSource=" + String.valueOf(this.streamSource)).toString();
    }
}

