/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Prioritisable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class SortedConcurrentPrioritisableSet<T extends Prioritisable>
implements Iterable<T> {
    private final AtomicLong insertionCount = new AtomicLong();
    private final ConcurrentSkipListSet<T> set = new ConcurrentSkipListSet<Prioritisable>(this.sortedByPriorityThenReverseInsertionOrder());

    private Comparator<Prioritisable> sortedByPriorityThenReverseInsertionOrder() {
        return (one, two) -> {
            int priorityComparison = SortedConcurrentPrioritisableSet.comparePriorityWith(one, two);
            if (priorityComparison != 0) {
                return priorityComparison;
            }
            return Long.compare(two.getInsertionIndex(), one.getInsertionIndex());
        };
    }

    private static int comparePriorityWith(Prioritisable one, Prioritisable two) {
        int thisPriority = ParameterUtils.getFirstNonNull(one.getPriority(), 5);
        int otherPriority = ParameterUtils.getFirstNonNull(two.getPriority(), 5);
        return thisPriority - otherPriority;
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    public Stream<T> stream() {
        return this.set.stream();
    }

    public T add(T mapping) {
        mapping = mapping.withInsertionIndex(this.insertionCount.getAndIncrement());
        boolean actuallyAdded = this.set.add(mapping);
        return mapping;
    }

    public boolean remove(UUID mappingId) {
        return this.set.removeIf(mapping -> mappingId != null && mappingId.equals(mapping.getId()));
    }

    public T replace(T existingItem, T newItem) {
        if (this.set.remove(existingItem)) {
            this.set.add(newItem);
        }
        return newItem;
    }

    public void clear() {
        this.set.clear();
    }

    public String toString() {
        return this.set.toString();
    }
}

