/*
 * Copyright (C) 2025-2026 Thomas Akehurst
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = IncomingMessageTrigger.class)
@JsonSubTypes({
  @JsonSubTypes.Type(value = IncomingMessageTrigger.class, name = "message"),
  @JsonSubTypes.Type(value = HttpStubTrigger.class, name = "http-stub"),
  @JsonSubTypes.Type(value = HttpRequestTrigger.class, name = "http-request")
})
public interface MessageTrigger {

  MessageTrigger ANYTHING = IncomingMessageTrigger.ANYTHING;
}
