/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.RequestCache;
import com.github.tomakehurst.wiremock.extension.requestfilter.ContinueAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.FilterProcessor;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterV2;
import com.github.tomakehurst.wiremock.extension.requestfilter.StopAction;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestEventSource;
import com.github.tomakehurst.wiremock.http.RequestHandler;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractRequestHandler
implements RequestHandler,
RequestEventSource {
    protected List<RequestListener> listeners = new ArrayList<RequestListener>();
    protected final ResponseRenderer responseRenderer;
    protected final FilterProcessor filterProcessor;
    private final DataTruncationSettings dataTruncationSettings;

    public AbstractRequestHandler(ResponseRenderer responseRenderer, List<RequestFilter> requestFilters, List<RequestFilterV2> v2RequestFilters, DataTruncationSettings dataTruncationSettings) {
        this.responseRenderer = responseRenderer;
        this.filterProcessor = new FilterProcessor(requestFilters, v2RequestFilters);
        this.dataTruncationSettings = dataTruncationSettings;
    }

    @Override
    public void addRequestListener(RequestListener requestListener) {
        this.listeners.add(requestListener);
    }

    protected void beforeResponseSent(ServeEvent serveEvent, Response response) {
    }

    protected void afterResponseSent(ServeEvent serveEvent, Response response) {
    }

    @Override
    public void handle(Request request, HttpResponder httpResponder, ServeEvent originalServeEvent) {
        ServeEvent serveEvent = ServeEvent.of(request);
        Request processedRequest = request;
        if (this.filterProcessor.hasAnyFilters()) {
            RequestFilterAction requestFilterAction = this.filterProcessor.processFilters(request, serveEvent);
            if (requestFilterAction instanceof ContinueAction) {
                processedRequest = ((ContinueAction)requestFilterAction).getRequest();
                serveEvent = this.handleRequest(serveEvent.replaceRequest(processedRequest));
            } else {
                serveEvent = serveEvent.withResponseDefinition(((StopAction)requestFilterAction).getResponseDefinition());
            }
        } else {
            serveEvent = this.handleRequest(serveEvent);
        }
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        Response response = this.responseRenderer.render(serveEvent);
        response = Response.Builder.like(response).protocol(request.getProtocol()).build();
        serveEvent = serveEvent.complete(response, this.dataTruncationSettings);
        if (this.logRequests()) {
            LocalNotifier.notifier().info("Request received:\n" + this.formatRequest(request) + "\n\nMatched response definition:\n" + String.valueOf(responseDefinition) + "\n\nResponse:\n" + String.valueOf(response));
        }
        for (RequestListener listener : this.listeners) {
            listener.requestReceived(request, response);
        }
        this.beforeResponseSent(serveEvent, response);
        serveEvent.beforeSend();
        Map<String, Object> attributes = Map.of("wiremock.ORIGINAL_SERVE_EVENT", serveEvent);
        httpResponder.respond(request, response, attributes);
        serveEvent.afterSend();
        this.afterResponseSent(serveEvent, response);
        RequestCache.onRequestEnd();
    }

    protected String formatRequest(Request request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getClientIp()).append(" - ").append(request.getMethod()).append(" ").append(request.getPathAndQueryWithoutPrefix());
        if (request.isBrowserProxyRequest()) {
            sb.append(" (via browser proxy request)");
        }
        sb.append("\n\n");
        sb.append(request.getHeaders());
        if (request.getBody() != null) {
            sb.append(request.getBodyAsString()).append("\n");
        }
        return sb.toString();
    }

    protected boolean logRequests() {
        return false;
    }

    protected abstract ServeEvent handleRequest(ServeEvent var1);
}

