/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.RequestCache;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HelperUtils;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public class JsonSortHelper
extends HandlebarsHelper<Object> {
    private final ParseContext parseContext = JsonPath.using((Configuration)HelperUtils.jsonPathConfig);

    public Object apply(Object inputJson, Options options) throws IOException {
        Object arrayObject;
        List sortValues;
        DocumentContext jsonDocument;
        String arrayPath;
        Object nullsParam;
        Object orderParam;
        if (!(inputJson instanceof String)) {
            return this.handleError("Input JSON must be a string");
        }
        if (inputJson.equals("null")) {
            return this.handleError("Cannot sort a JSON null value - input must be a JSON array");
        }
        if (options.params.length != 1) {
            return this.handleError("A single JSONPath expression parameter must be supplied");
        }
        Object jsonPathString = options.param(0);
        if (!(jsonPathString instanceof String)) {
            return this.handleError("JSONPath parameter must be a string");
        }
        String order = "asc";
        if (options.hash != null && (orderParam = options.hash.get("order")) != null) {
            if (!(orderParam instanceof String)) {
                return this.handleError("order parameter must be a string");
            }
            order = (String)orderParam;
            if (!order.equals("asc") && !order.equals("desc")) {
                return this.handleError("order parameter must be 'asc' or 'desc'");
            }
        }
        String nullsPlacement = "first";
        if (options.hash != null && (nullsParam = options.hash.get("nulls")) != null) {
            if (!(nullsParam instanceof String)) {
                return this.handleError("nulls parameter must be a string");
            }
            nullsPlacement = (String)nullsParam;
            if (!nullsPlacement.equals("first") && !nullsPlacement.equals("last")) {
                return this.handleError("nulls parameter must be 'first' or 'last'");
            }
        }
        if ((arrayPath = this.extractArrayPath((String)jsonPathString)) == null) {
            return this.handleError("JSONPath must include [*] to specify array location (e.g., '$[*].name' or '$.users[*].name')");
        }
        try {
            jsonDocument = this.getParsedDocument((String)inputJson, options);
        }
        catch (Exception e) {
            return this.handleError("Input JSON string is not valid JSON ('" + String.valueOf(inputJson) + "')", e);
        }
        try {
            sortValues = this.readJsonPath(jsonDocument, (String)jsonPathString, List.class, options);
        }
        catch (PathNotFoundException e) {
            return this.handleError("JSONPath expression did not match any values ('" + String.valueOf(jsonPathString) + "')", e);
        }
        catch (Exception e) {
            return this.handleError("Invalid JSONPath expression ('" + String.valueOf(jsonPathString) + "')", e);
        }
        try {
            arrayObject = this.readJsonPath(jsonDocument, arrayPath, Object.class, options);
        }
        catch (PathNotFoundException e) {
            return this.handleError("Array not found at path ('" + arrayPath + "')", e);
        }
        catch (Exception e) {
            return this.handleError("Error reading array at path ('" + arrayPath + "')", e);
        }
        if (!(arrayObject instanceof List)) {
            return this.handleError("JSONPath does not reference an array ('" + arrayPath + "')");
        }
        List array = (List)arrayObject;
        if (sortValues.size() != array.size()) {
            return this.handleError(this.getError(sortValues, array, (String)jsonPathString));
        }
        if (array.isEmpty()) {
            return jsonDocument.jsonString();
        }
        Class<?> commonType = this.detectCommonType(sortValues);
        if (commonType == null) {
            return this.handleError("All sort field values must be of the same comparable type (Number, String, or Boolean)");
        }
        if (array.size() == 1) {
            return jsonDocument.jsonString();
        }
        ArrayList<SortPair> pairs = new ArrayList<SortPair>();
        for (int i = 0; i < array.size(); ++i) {
            pairs.add(new SortPair(array.get(i), sortValues.get(i)));
        }
        Comparator<Object> valueComparator = this.createComparator(commonType, nullsPlacement);
        if ("desc".equals(order)) {
            valueComparator = valueComparator.reversed();
        }
        Comparator<Object> finalComparator = valueComparator;
        pairs.sort((a, b) -> finalComparator.compare(a.sortValue, b.sortValue));
        List sortedArray = pairs.stream().map(p -> p.object).collect(Collectors.toList());
        if ("$".equals(arrayPath)) {
            return this.parseContext.parse(sortedArray).jsonString();
        }
        jsonDocument.set(arrayPath, sortedArray, new Predicate[0]);
        return jsonDocument.jsonString();
    }

    private @NonNull String getError(List<?> sortValues, List<Object> array, String jsonPathString) {
        String errorMsg = "Number of sort values (" + sortValues.size() + ") does not match array size (" + array.size() + ")";
        int wildcardCount = this.countWildcards(jsonPathString);
        if (wildcardCount > 1) {
            errorMsg = errorMsg + ". JSONPath contains " + wildcardCount + " wildcards [*] but only single-level array sorting is supported";
        }
        return errorMsg;
    }

    private String extractArrayPath(String jsonPath) {
        int wildcardIndex = jsonPath.indexOf("[*]");
        if (wildcardIndex == -1) {
            return null;
        }
        String path = jsonPath.substring(0, wildcardIndex);
        return path.isEmpty() ? "$" : path;
    }

    private int countWildcards(String jsonPath) {
        int count = 0;
        int index = 0;
        while ((index = jsonPath.indexOf("[*]", index)) != -1) {
            ++count;
            index += 3;
        }
        return count;
    }

    private Class<?> detectCommonType(List<?> values) {
        if (values.isEmpty()) {
            return null;
        }
        Class firstType = null;
        for (Object value : values) {
            if (value == null) continue;
            Class<?> currentType = this.getComparableType(value);
            if (currentType == null) {
                return null;
            }
            if (firstType == null) {
                firstType = currentType;
                continue;
            }
            if (firstType.equals(currentType)) continue;
            return null;
        }
        return firstType != null ? firstType : String.class;
    }

    private Class<?> getComparableType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Number.class;
        }
        if (value instanceof String) {
            return String.class;
        }
        if (value instanceof Boolean) {
            return Boolean.class;
        }
        return null;
    }

    private Comparator<Object> createComparator(Class<?> type, String nullsPlacement) {
        Comparator<Object> baseComparator;
        if (Number.class.equals(type)) {
            baseComparator = (a, b) -> {
                BigDecimal bdA = this.toBigDecimal((Number)a);
                BigDecimal bdB = this.toBigDecimal((Number)b);
                return bdA.compareTo(bdB);
            };
        } else if (String.class.equals(type)) {
            baseComparator = Comparator.comparing(v -> (String)v);
        } else if (Boolean.class.equals(type)) {
            baseComparator = Comparator.comparing(v -> (Boolean)v);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
        }
        return "last".equals(nullsPlacement) ? Comparator.nullsLast(baseComparator) : Comparator.nullsFirst(baseComparator);
    }

    private BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof Float || number instanceof Double) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        return new BigDecimal(number.toString());
    }

    private DocumentContext getParsedDocument(String json, Options options) {
        RequestCache requestCache = JsonSortHelper.getRequestCache(options);
        RequestCache.Key cacheKey = RequestCache.Key.keyFor(DocumentContext.class, json);
        DocumentContext document = (DocumentContext)requestCache.get(cacheKey);
        if (document == null) {
            document = this.parseContext.parse(json);
            requestCache.put(cacheKey, document);
        }
        return document;
    }

    private <T> T readJsonPath(DocumentContext document, String jsonPath, Class<T> returnType, Options options) {
        RequestCache requestCache = JsonSortHelper.getRequestCache(options);
        RequestCache.Key cacheKey = RequestCache.Key.keyFor(returnType, jsonPath, document);
        Object value = requestCache.get(cacheKey);
        if (value == null) {
            value = document.read(jsonPath, returnType, new Predicate[0]);
            requestCache.put(cacheKey, value);
        }
        return value;
    }

    private record SortPair(Object object, Object sortValue) {
    }
}

