/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class JoinHelper
extends HandlebarsHelper<Object> {
    public Object apply(Object context, Options options) throws IOException {
        if (!(context instanceof String)) {
            return this.handleError("Separator parameter must be a String");
        }
        String separator = (String)context;
        Object firstParam = options.param(0, null);
        if (firstParam == null) {
            return this.handleError("The parameter must be list");
        }
        List<Object> items = Iterable.class.isAssignableFrom(firstParam.getClass()) ? (List<Object>)firstParam : Arrays.asList(options.params);
        String prefix = (String)options.hash("prefix", (Object)"");
        String suffix = (String)options.hash("suffix", (Object)"");
        if (items.isEmpty()) {
            return "";
        }
        String result = options.tagType == TagType.SECTION ? JoinHelper.processSection(options, separator, items) : JoinHelper.processWithoutSection(separator, items);
        return prefix + result + suffix;
    }

    private static String processWithoutSection(String separator, List<Object> items) {
        StringBuilder sb = new StringBuilder();
        boolean initialised = false;
        for (Object item : items) {
            if (initialised) {
                sb.append(separator);
            }
            sb.append(item.toString());
            initialised = true;
        }
        return sb.toString();
    }

    private static String processSection(Options options, String separator, List<Object> list) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            CharSequence itemRendered = options.fn(list.get(i));
            sb.append(itemRendered);
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

