/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.RequestCache;
import com.github.tomakehurst.wiremock.common.xml.XPathException;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.common.xml.XmlDocument;
import com.github.tomakehurst.wiremock.common.xml.XmlException;
import com.github.tomakehurst.wiremock.common.xml.XmlNode;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;

public class HandlebarsXPathHelper
extends HandlebarsHelper<String> {
    public Object apply(String inputXml, Options options) throws IOException {
        XmlDocument xmlDocument;
        if (inputXml == null) {
            return "";
        }
        if (options.param(0, null) == null) {
            return this.handleError("The XPath expression cannot be empty");
        }
        String xPathInput = (String)options.param(0);
        try {
            xmlDocument = this.getXmlDocument(inputXml, options);
        }
        catch (XmlException e) {
            return this.handleError(inputXml + " is not valid XML");
        }
        try {
            ListOrSingle<XmlNode> xmlNodes = this.getXmlNodes(this.getXPathPrefix() + xPathInput, xmlDocument, options);
            if (xmlNodes == null || xmlNodes.isEmpty()) {
                return "";
            }
            return xmlNodes;
        }
        catch (XPathException e) {
            return this.handleError(xPathInput + " is not a valid XPath expression", e);
        }
    }

    private ListOrSingle<XmlNode> getXmlNodes(String xPathExpression, XmlDocument doc, Options options) {
        RequestCache requestCache = HandlebarsXPathHelper.getRequestCache(options);
        RequestCache.Key cacheKey = RequestCache.Key.keyFor(XmlDocument.class, xPathExpression, doc);
        ListOrSingle<XmlNode> nodes = (ListOrSingle<XmlNode>)requestCache.get(cacheKey);
        if (nodes == null) {
            nodes = doc.findNodes(xPathExpression);
            requestCache.put(cacheKey, nodes);
        }
        return nodes;
    }

    private XmlDocument getXmlDocument(String xml, Options options) {
        RequestCache requestCache = HandlebarsXPathHelper.getRequestCache(options);
        RequestCache.Key cacheKey = RequestCache.Key.keyFor(XmlDocument.class, xml);
        XmlDocument document = (XmlDocument)requestCache.get(cacheKey);
        if (document == null) {
            document = Xml.parse(xml);
            requestCache.put(cacheKey, document);
        }
        return document;
    }

    protected String getXPathPrefix() {
        return "";
    }
}

