/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.url.PathParams;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.wiremock.url.Path;
import org.wiremock.url.PathAndQuery;
import org.wiremock.url.Segment;

public class TemplatedUrlPath
extends LinkedHashMap<String, String>
implements Iterable<String> {
    private final Path originalPath;

    public TemplatedUrlPath(PathAndQuery url, PathParams pathParams) {
        this.originalPath = url.getPath();
        this.addAllPathSegments();
        this.putAll(pathParams);
    }

    private void addAllPathSegments() {
        List pathSegments = this.originalPath.getSegments();
        int i = 0;
        for (Segment pathNode : pathSegments) {
            if (pathNode.isEmpty()) continue;
            String key = String.valueOf(i++);
            this.put(key, pathNode.toString());
        }
    }

    @Override
    public String toString() {
        return this.originalPath.toString();
    }

    @Override
    public Iterator<String> iterator() {
        return this.originalPath.getSegments().stream().map(Object::toString).iterator();
    }
}

