/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.wiremock.url.Query;
import org.wiremock.url.QueryParamValue;

public class Conversions {
    public static Integer toInt(Query query, String key) {
        QueryParamValue parameter = query.getFirst(key);
        return parameter != null ? Integer.valueOf(parameter.decode()) : null;
    }

    public static Date toDate(Query query, String key) {
        QueryParamValue parameter = query.getFirst(key);
        try {
            return parameter != null ? Date.from(ZonedDateTime.parse(parameter.decode()).toInstant()) : null;
        }
        catch (DateTimeParseException e) {
            throw new InvalidInputException(Errors.validation(key, parameter.decode() + " is not a valid ISO8601 date"));
        }
    }
}

