/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.common.Prioritisable;
import com.github.tomakehurst.wiremock.common.SortedConcurrentPrioritisableSet;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public abstract class InMemoryMappingStore<T extends Prioritisable> {
    private final SortedConcurrentPrioritisableSet<T> mappings = new SortedConcurrentPrioritisableSet();

    public Optional<T> get(UUID id) {
        return this.mappings.stream().filter(mapping -> mapping.getId().equals(id)).findFirst();
    }

    public void remove(UUID id) {
        this.mappings.remove(id);
    }

    public void clear() {
        this.mappings.clear();
    }

    public Stream<T> getAll() {
        return this.mappings.stream();
    }

    public T add(T mapping) {
        return this.mappings.add(mapping);
    }

    public T replace(T existing, T updated) {
        return this.mappings.replace(existing, updated);
    }
}

