/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message.websocket;

import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.message.ChannelType;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.message.websocket.WebSocketSession;
import java.util.UUID;

public class WebSocketMessageChannel
implements RequestInitiatedMessageChannel {
    private final UUID id;
    private final Request request;
    private final WebSocketSession session;

    public WebSocketMessageChannel(UUID id, Request request, WebSocketSession session) {
        this.id = id;
        this.request = request;
        this.session = session;
    }

    public WebSocketMessageChannel(Request request, WebSocketSession session) {
        this(UUID.randomUUID(), request, session);
    }

    @Override
    public ChannelType getType() {
        return ChannelType.WEBSOCKET;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Request getInitiatingRequest() {
        return this.request;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public boolean isOpen() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public void sendMessage(Message message) {
        if (this.session != null && this.session.isOpen()) {
            this.session.sendMessage(message);
        }
    }

    @Override
    public void close() {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
    }
}

