/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.entity.EntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.StringEntityDefinition;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.message.ChannelTarget;
import com.github.tomakehurst.wiremock.message.MessageAction;
import com.github.tomakehurst.wiremock.message.MessageDefinition;
import com.github.tomakehurst.wiremock.message.OriginatingChannelTarget;
import com.github.tomakehurst.wiremock.message.RequestInitiatedChannelTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class SendMessageAction
implements MessageAction {
    private final @NonNull MessageDefinition message;
    private final @NonNull ChannelTarget channelTarget;
    private final @NonNull List<String> transformers;
    private final @NonNull Parameters transformerParameters;

    @JsonCreator
    public SendMessageAction(@JsonProperty(value="message") MessageDefinition message, @JsonProperty(value="channelTarget") ChannelTarget channelTarget, @JsonProperty(value="transformers") List<String> transformers, @JsonProperty(value="transformerParameters") Parameters transformerParameters) {
        this.message = message;
        this.channelTarget = channelTarget != null ? channelTarget : OriginatingChannelTarget.INSTANCE;
        this.transformers = transformers != null ? new ArrayList<String>(transformers) : new ArrayList();
        this.transformerParameters = transformerParameters != null ? transformerParameters : Parameters.empty();
    }

    public static SendMessageAction toOriginatingChannel(EntityDefinition body) {
        return new SendMessageAction(new MessageDefinition(body), OriginatingChannelTarget.INSTANCE, null, null);
    }

    public static SendMessageAction toOriginatingChannel(String messageBody) {
        return SendMessageAction.toOriginatingChannel(new StringEntityDefinition(messageBody));
    }

    public static SendMessageAction toMatchingChannels(EntityDefinition body, RequestPattern targetChannelPattern) {
        return new SendMessageAction(new MessageDefinition(body), RequestInitiatedChannelTarget.forPattern(targetChannelPattern), null, null);
    }

    public static SendMessageAction toMatchingChannels(String messageBody, RequestPattern targetChannelPattern) {
        return SendMessageAction.toMatchingChannels(new StringEntityDefinition(messageBody), targetChannelPattern);
    }

    public MessageDefinition getMessage() {
        return this.message;
    }

    @JsonIgnore
    public EntityDefinition getBody() {
        return this.message != null ? this.message.getBody() : null;
    }

    public ChannelTarget getChannelTarget() {
        return this.channelTarget;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Parameters getTransformerParameters() {
        return this.transformerParameters;
    }

    @Override
    public boolean hasTransformer(Extension transformer) {
        return this.transformers.contains(transformer.getName());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendMessageAction that = (SendMessageAction)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.channelTarget, that.channelTarget) && Objects.equals(this.transformers, that.transformers) && Objects.equals(this.transformerParameters, that.transformerParameters);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.channelTarget, this.transformers, this.transformerParameters);
    }

    public String toString() {
        return "SendMessageAction{message='" + String.valueOf(this.message) + "', channelTarget=" + String.valueOf(this.channelTarget) + ", transformers=" + String.valueOf(this.transformers) + "}";
    }
}

