/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessageStubMapping;
import com.github.tomakehurst.wiremock.store.MessageStubMappingStore;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class MessageStubMappings {
    private final MessageStubMappingStore store;

    public MessageStubMappings(MessageStubMappingStore store) {
        this.store = store;
    }

    public void add(MessageStubMapping mapping) {
        this.store.add(mapping);
    }

    public void remove(UUID id) {
        this.store.remove(id);
    }

    public Optional<MessageStubMapping> get(UUID id) {
        return this.store.get(id);
    }

    public List<MessageStubMapping> getAll() {
        return this.store.getAll().collect(Collectors.toList());
    }

    public List<MessageStubMapping> getAllSortedByPriority() {
        return this.store.getAll().sorted(Comparator.comparingInt(m -> m.getPriority() != null ? m.getPriority() : 5)).collect(Collectors.toList());
    }

    public void clear() {
        this.store.clear();
    }

    public int size() {
        return (int)this.store.getAll().count();
    }

    public Optional<MessageStubMapping> findMatchingStub(MessageChannel channel, Message message) {
        return this.getAllSortedByPriority().stream().filter(stub -> stub.matches(channel, message)).findFirst();
    }

    public List<MessageStubMapping> findByMetadata(StringValuePattern pattern) {
        return this.store.getAll().filter(stubMapping -> {
            String metadataJson = Json.write(stubMapping.getMetadata());
            return pattern.match(metadataJson).isExactMatch();
        }).collect(Collectors.toList());
    }
}

