/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.github.tomakehurst.wiremock.client.MessageStubMappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.common.Prioritisable;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.message.ChannelPattern;
import com.github.tomakehurst.wiremock.message.ChannelType;
import com.github.tomakehurst.wiremock.message.HttpRequestTrigger;
import com.github.tomakehurst.wiremock.message.HttpStubTrigger;
import com.github.tomakehurst.wiremock.message.IncomingMessageTrigger;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageAction;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessagePattern;
import com.github.tomakehurst.wiremock.message.MessageTrigger;
import com.github.tomakehurst.wiremock.message.RequestInitiatedChannelPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(value={"$schema", "uuid", "insertionIndex"})
public class MessageStubMapping
implements Prioritisable {
    public static final int DEFAULT_PRIORITY = 5;
    private final UUID id;
    private final String name;
    private final Integer priority;
    private final @NonNull MessageTrigger trigger;
    private final @NonNull List<MessageAction> actions;
    private final @NonNull Metadata metadata;
    private final long insertionIndex;

    @JsonCreator
    public MessageStubMapping(@JsonProperty(value="id") UUID id, @JsonProperty(value="name") String name, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="trigger") MessageTrigger trigger, @JsonProperty(value="actions") List<MessageAction> actions, @JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="insertionIndex") @JsonView(value={Json.PrivateView.class}) long insertionIndex) {
        this.id = id != null ? id : UUID.randomUUID();
        this.name = name;
        this.priority = priority;
        this.trigger = trigger != null ? trigger : IncomingMessageTrigger.ANYTHING;
        this.actions = actions != null ? actions : Collections.emptyList();
        this.metadata = metadata != null ? metadata : new Metadata();
        this.insertionIndex = insertionIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MessageStubMapping create(Consumer<Builder> transformer) {
        Builder builder = MessageStubMapping.builder();
        transformer.accept(builder);
        return builder.build();
    }

    public MessageStubMapping transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    public MessageTrigger getTrigger() {
        return this.trigger;
    }

    public List<MessageAction> getActions() {
        return this.actions;
    }

    public @NonNull Metadata getMetadata() {
        return this.metadata;
    }

    public boolean matches(MessageChannel channel, Message message) {
        MessageTrigger messageTrigger = this.trigger;
        if (messageTrigger instanceof IncomingMessageTrigger) {
            IncomingMessageTrigger messageTrigger2 = (IncomingMessageTrigger)messageTrigger;
            return messageTrigger2.matches(channel, message);
        }
        return false;
    }

    @Override
    public long getInsertionIndex() {
        return this.insertionIndex;
    }

    @Override
    public <T extends Prioritisable> T withInsertionIndex(long newInsertionIndex) {
        return (T)this.transform(builder -> builder.setInsertionIndex(newInsertionIndex));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageStubMapping that = (MessageStubMapping)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.priority, that.priority) && Objects.equals(this.trigger, that.trigger) && Objects.equals(this.actions, that.actions) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.priority, this.trigger, this.actions, this.metadata);
    }

    public String toString() {
        return Json.write(this);
    }

    public static class Builder
    implements MessageStubMappingBuilder {
        private UUID id;
        private String name;
        private Integer priority;
        private ChannelPattern channelPattern;
        private ContentPattern<?> bodyPattern;
        private MessageTrigger explicitTrigger;
        private ArrayList<MessageAction> actions = new ArrayList();
        private @NonNull Metadata metadata = new Metadata();
        private long insertionIndex;

        public Builder() {
        }

        public Builder(MessageStubMapping existing) {
            this.id = existing.id;
            this.name = existing.name;
            this.priority = existing.priority;
            MessageTrigger messageTrigger = existing.trigger;
            if (messageTrigger instanceof IncomingMessageTrigger) {
                IncomingMessageTrigger incomingTrigger = (IncomingMessageTrigger)messageTrigger;
                this.channelPattern = incomingTrigger.getChannel();
                if (incomingTrigger.getMessage() != null) {
                    this.bodyPattern = incomingTrigger.getMessage().getBodyPattern();
                }
            } else {
                this.explicitTrigger = existing.trigger;
            }
            this.actions = new ArrayList<MessageAction>(existing.actions);
            this.metadata = existing.metadata;
            this.insertionIndex = existing.insertionIndex;
        }

        @Override
        public Builder withId(UUID id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder atPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder withPriority(Integer priority) {
            return this.atPriority(priority);
        }

        @Override
        public Builder withMessageBody(StringValuePattern messagePattern) {
            this.bodyPattern = messagePattern;
            return this;
        }

        public Builder onWebsocketChannelFromRequestMatching(String urlPath) {
            return this.onChannelFromRequestMatching(ChannelType.WEBSOCKET, RequestPatternBuilder.newRequestPattern().withUrl(WireMock.urlPathEqualTo(urlPath)));
        }

        public Builder onWebsocketChannelFromRequestMatching(RequestPatternBuilder channelPatternBuilder) {
            return this.onChannelFromRequestMatching(ChannelType.WEBSOCKET, channelPatternBuilder.build());
        }

        public Builder onChannelFromRequestMatching(ChannelType channelType, String urlPath) {
            return this.onChannelFromRequestMatching(channelType, RequestPatternBuilder.newRequestPattern().withUrl(WireMock.urlPathEqualTo(urlPath)));
        }

        public Builder onChannelFromRequestMatching(ChannelType channelType, RequestPatternBuilder channelPatternBuilder) {
            return this.onChannelFromRequestMatching(channelType, channelPatternBuilder.build());
        }

        public Builder onChannelFromRequestMatching(ChannelType channelType, RequestPattern requestPattern) {
            this.channelPattern = RequestInitiatedChannelPattern.forRequestPattern(channelType, requestPattern);
            return this;
        }

        public Builder withBody(ContentPattern<?> bodyPattern) {
            this.bodyPattern = bodyPattern;
            return this;
        }

        public Builder triggeredByHttpStub(UUID stubId) {
            this.explicitTrigger = HttpStubTrigger.forStubId(stubId);
            return this;
        }

        public Builder triggeredByHttpStub(String stubId) {
            this.explicitTrigger = HttpStubTrigger.forStubId(stubId);
            return this;
        }

        public Builder triggeredByHttpRequest(RequestPattern requestPattern) {
            this.explicitTrigger = HttpRequestTrigger.forRequestPattern(requestPattern);
            return this;
        }

        public Builder triggeredByHttpRequest(RequestPatternBuilder requestPatternBuilder) {
            this.explicitTrigger = HttpRequestTrigger.forRequestPattern(requestPatternBuilder.build());
            return this;
        }

        public Builder withActions(List<MessageAction> actions) {
            this.actions = new ArrayList<MessageAction>(actions);
            return this;
        }

        @Override
        public MessageStubMapping willTriggerActions(MessageAction ... actions) {
            this.actions.addAll(Arrays.asList(actions));
            return this.build();
        }

        public Builder triggersAction(MessageAction action) {
            this.actions.add(action);
            return this;
        }

        @Override
        public Builder withMetadata(Map<String, ?> metadataMap) {
            this.metadata = new Metadata(metadataMap);
            return this;
        }

        @Override
        public Builder withMetadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public Builder withMetadata(Metadata.Builder metadata) {
            this.metadata = metadata.build();
            return this;
        }

        public long getInsertionIndex() {
            return this.insertionIndex;
        }

        public Builder setInsertionIndex(long insertionIndex) {
            this.insertionIndex = insertionIndex;
            return this;
        }

        @Override
        public MessageStubMapping build() {
            MessageTrigger trigger;
            if (this.explicitTrigger != null) {
                trigger = this.explicitTrigger;
            } else {
                MessagePattern messagePattern = this.bodyPattern != null ? new MessagePattern(null, this.bodyPattern) : null;
                trigger = new IncomingMessageTrigger(this.channelPattern, messagePattern);
            }
            return new MessageStubMapping(this.id, this.name, this.priority, trigger, this.actions, this.metadata, this.insertionIndex);
        }
    }
}

