/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.entity.BinaryEntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.EntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.StringEntityDefinition;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageDefinition {
    private final EntityDefinition body;

    @JsonCreator
    public MessageDefinition(@JsonProperty(value="body") EntityDefinition body) {
        this.body = body;
    }

    public static MessageDefinition fromString(String message) {
        return new MessageDefinition(new StringEntityDefinition(message));
    }

    public static MessageDefinition fromBytes(byte[] data) {
        return new MessageDefinition(BinaryEntityDefinition.aBinaryMessage().withBody(data).build());
    }

    public EntityDefinition getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageDefinition that = (MessageDefinition)o;
        return Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hashCode(this.body);
    }
}

