/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.util.UUID;

public class HandlebarsRandomValuesHelper
extends HandlebarsHelper<Void> {
    public Object apply(Void context, Options options) throws IOException {
        String type;
        int length = (Integer)options.hash("length", (Object)36);
        boolean uppercase = (Boolean)options.hash("uppercase", (Object)false);
        String rawValue = switch (type = (String)options.hash("type", (Object)"ALPHANUMERIC")) {
            case "ALPHANUMERIC" -> Strings.randomAlphanumeric(length);
            case "ALPHABETIC" -> Strings.randomAlphabetic(length);
            case "NUMERIC" -> Strings.randomNumeric(length);
            case "ALPHANUMERIC_AND_SYMBOLS" -> Strings.random(length, 33, 126, false, false);
            case "UUID" -> UUID.randomUUID().toString();
            case "HEXADECIMAL" -> Strings.random(length, "ABCDEF0123456789");
            default -> Strings.randomAscii(length);
        };
        return uppercase ? rawValue.toUpperCase() : rawValue.toLowerCase();
    }
}

