/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.common.entity.CompressionType;
import com.github.tomakehurst.wiremock.common.entity.EncodingType;
import com.github.tomakehurst.wiremock.common.entity.EntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.FormatType;
import java.util.Objects;

@JsonDeserialize(as=StringEntityDefinition.class)
public class StringEntityDefinition
extends EntityDefinition {
    private final String value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public StringEntityDefinition(String v) {
        this.value = v;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringEntityDefinition that = (StringEntityDefinition)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public EncodingType getEncoding() {
        return EncodingType.TEXT;
    }

    @Override
    public FormatType getFormat() {
        return FormatType.TEXT;
    }

    @Override
    public CompressionType getCompression() {
        return CompressionType.NONE;
    }

    @Override
    public Object getData() {
        return this.value;
    }
}

